/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.feature;

import java.util.ArrayList;
import java.util.List;
import org.apache.spark.ml.feature.OneHotEncoder;
import org.apache.spark.ml.param.Param;
import org.dmg.pmml.DataType;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.sparkml.FeatureConverter;
import org.jpmml.sparkml.SparkMLEncoder;
import scala.Option;

public class OneHotEncoderConverter
extends FeatureConverter<OneHotEncoder> {
    public OneHotEncoderConverter(OneHotEncoder transformer) {
        super(transformer);
    }

    @Override
    public List<Feature> encodeFeatures(SparkMLEncoder encoder) {
        OneHotEncoder transformer = (OneHotEncoder)this.getTransformer();
        CategoricalFeature feature = (CategoricalFeature)encoder.getOnlyFeature(transformer.getInputCol());
        List values = feature.getValues();
        boolean dropLast = true;
        Option dropLastOption = transformer.get((Param)transformer.dropLast());
        if (dropLastOption.isDefined()) {
            dropLast = (Boolean)dropLastOption.get();
        }
        if (dropLast) {
            values = values.subList(0, values.size() - 1);
        }
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (String value : values) {
            result.add((Feature)new BinaryFeature((PMMLEncoder)encoder, feature.getName(), DataType.STRING, value));
        }
        return result;
    }
}

