/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml;

import java.util.Collections;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.sparkml.ModelConverter;
import org.jpmml.sparkml.SparkMLEncoder;

public abstract class ClusteringModelConverter<T extends Model<T> & HasPredictionCol>
extends ModelConverter<T> {
    public ClusteringModelConverter(T model) {
        super(model);
    }

    @Override
    public MiningFunction getMiningFunction() {
        return MiningFunction.CLUSTERING;
    }

    @Override
    public Output encodeOutput(Label label, SparkMLEncoder encoder) {
        Model model = (Model)this.getTransformer();
        HasPredictionCol hasPredictionCol = (HasPredictionCol)model;
        String predictionCol = hasPredictionCol.getPredictionCol();
        OutputField predictedField = ModelUtil.createPredictedField((FieldName)FieldName.create((String)predictionCol), (DataType)DataType.STRING, (OpType)OpType.CATEGORICAL);
        Output output = new Output().addOutputFields(new OutputField[]{predictedField});
        Feature feature = new Feature((PMMLEncoder)encoder, predictedField.getName(), predictedField.getDataType()){

            public ContinuousFeature toContinuousFeature() {
                throw new UnsupportedOperationException();
            }
        };
        encoder.putFeatures(predictionCol, Collections.singletonList(feature));
        return output;
    }
}

