/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.feature;

import java.util.ArrayList;
import java.util.List;
import org.apache.spark.ml.feature.StandardScalerModel;
import org.apache.spark.ml.linalg.Vector;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.OpType;
import org.dmg.pmml.TypeDefinitionField;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sparkml.FeatureConverter;
import org.jpmml.sparkml.SparkMLEncoder;

public class StandardScalerModelConverter
extends FeatureConverter<StandardScalerModel> {
    public StandardScalerModelConverter(StandardScalerModel transformer) {
        super(transformer);
    }

    @Override
    public List<Feature> encodeFeatures(SparkMLEncoder encoder) {
        StandardScalerModel transformer = (StandardScalerModel)this.getTransformer();
        List<Feature> features = encoder.getFeatures(transformer.getInputCol());
        Vector mean = transformer.mean();
        if (transformer.getWithMean() && mean.size() != features.size()) {
            throw new IllegalArgumentException();
        }
        Vector std = transformer.std();
        if (transformer.getWithStd() && std.size() != features.size()) {
            throw new IllegalArgumentException();
        }
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < features.size(); ++i) {
            double stdValue;
            double meanValue;
            Feature feature = features.get(i);
            ContinuousFeature continuousFeature = feature.toContinuousFeature();
            FieldRef expression = continuousFeature.ref();
            if (transformer.getWithMean() && !ValueUtil.isZero((Number)(meanValue = mean.apply(i)))) {
                expression = PMMLUtil.createApply((String)"-", (Expression[])new Expression[]{expression, PMMLUtil.createConstant((Object)meanValue)});
            }
            if (transformer.getWithStd() && !ValueUtil.isOne((Number)(stdValue = std.apply(i)))) {
                expression = PMMLUtil.createApply((String)"*", (Expression[])new Expression[]{expression, PMMLUtil.createConstant((Object)(1.0 / stdValue))});
            }
            DerivedField derivedField = encoder.createDerivedField(StandardScalerModelConverter.formatName(transformer, i), OpType.CONTINUOUS, DataType.DOUBLE, (Expression)expression);
            result.add((Feature)new ContinuousFeature((PMMLEncoder)encoder, (TypeDefinitionField)derivedField));
        }
        return result;
    }
}

