/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.model;

import java.util.ArrayList;
import org.apache.spark.ml.classification.LogisticRegressionModel;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.Vector;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.regression.RegressionModel;
import org.dmg.pmml.regression.RegressionTable;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.regression.RegressionModelUtil;
import org.jpmml.sparkml.ClassificationModelConverter;
import org.jpmml.sparkml.MatrixUtil;
import org.jpmml.sparkml.ScaledFeatureUtil;
import org.jpmml.sparkml.VectorUtil;

public class LogisticRegressionModelConverter
extends ClassificationModelConverter<LogisticRegressionModel> {
    public LogisticRegressionModelConverter(LogisticRegressionModel model) {
        super(model);
    }

    public RegressionModel encodeModel(Schema schema) {
        LogisticRegressionModel model = (LogisticRegressionModel)this.getTransformer();
        CategoricalLabel categoricalLabel = (CategoricalLabel)schema.getLabel();
        if (categoricalLabel.size() == 2) {
            ArrayList<Feature> features = new ArrayList<Feature>(schema.getFeatures());
            ArrayList<Double> coefficients = new ArrayList<Double>(VectorUtil.toList(model.coefficients()));
            ScaledFeatureUtil.simplify(features, coefficients);
            RegressionModel regressionModel = RegressionModelUtil.createBinaryLogisticClassification(features, coefficients, (Double)model.intercept(), (RegressionModel.NormalizationMethod)RegressionModel.NormalizationMethod.LOGIT, (boolean)true, (Schema)schema).setOutput(null);
            return regressionModel;
        }
        if (categoricalLabel.size() > 2) {
            Matrix coefficientMatrix = model.coefficientMatrix();
            Vector interceptVector = model.interceptVector();
            ArrayList<RegressionTable> regressionTables = new ArrayList<RegressionTable>();
            for (int i = 0; i < categoricalLabel.size(); ++i) {
                ArrayList<Feature> features = new ArrayList<Feature>(schema.getFeatures());
                ArrayList<Double> coefficients = new ArrayList<Double>(MatrixUtil.getRow(coefficientMatrix, i));
                ScaledFeatureUtil.simplify(features, coefficients);
                RegressionTable regressionTable = RegressionModelUtil.createRegressionTable(features, coefficients, (Double)interceptVector.apply(i)).setTargetCategory(categoricalLabel.getValue(i));
                regressionTables.add(regressionTable);
            }
            RegressionModel regressionModel = new RegressionModel(MiningFunction.CLASSIFICATION, ModelUtil.createMiningSchema((Label)categoricalLabel), regressionTables).setNormalizationMethod(RegressionModel.NormalizationMethod.SOFTMAX);
            return regressionModel;
        }
        throw new IllegalArgumentException();
    }
}

