/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml;

import java.util.Iterator;
import java.util.List;
import org.apache.spark.sql.catalyst.expressions.Add;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.BinaryArithmetic;
import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.BinaryOperator;
import org.apache.spark.sql.catalyst.expressions.CaseWhen;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Divide;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.GreaterThan;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.IsNotNull;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.LessThan;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Multiply;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.catalyst.expressions.Subtract;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryMinus;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.HasDataType;
import org.dmg.pmml.Visitable;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.visitors.ExpressionCompactor;
import org.jpmml.sparkml.DatasetUtil;
import scala.Option;
import scala.Tuple2;
import scala.collection.JavaConversions;
import scala.collection.Seq;

public class ExpressionTranslator {
    public static Expression translate(org.apache.spark.sql.catalyst.expressions.Expression expression) {
        return ExpressionTranslator.translate(expression, true);
    }

    public static Expression translate(org.apache.spark.sql.catalyst.expressions.Expression expression, boolean compact) {
        Expression pmmlExpression = ExpressionTranslator.translateInternal(expression);
        if (compact) {
            ExpressionCompactor expressionCompactor = new ExpressionCompactor();
            expressionCompactor.applyTo((Visitable)pmmlExpression);
        }
        return pmmlExpression;
    }

    private static Expression translateInternal(org.apache.spark.sql.catalyst.expressions.Expression expression) {
        if (expression instanceof Alias) {
            Alias alias = (Alias)expression;
            org.apache.spark.sql.catalyst.expressions.Expression child = alias.child();
            return ExpressionTranslator.translateInternal(child);
        }
        if (expression instanceof AttributeReference) {
            AttributeReference attributeReference = (AttributeReference)expression;
            String name = attributeReference.name();
            return new FieldRef(FieldName.create((String)name));
        }
        if (expression instanceof BinaryOperator) {
            BinaryOperator binaryOperator = (BinaryOperator)expression;
            String symbol = binaryOperator.symbol();
            org.apache.spark.sql.catalyst.expressions.Expression left = binaryOperator.left();
            org.apache.spark.sql.catalyst.expressions.Expression right = binaryOperator.right();
            if (expression instanceof And || expression instanceof Or) {
                switch (symbol) {
                    case "&&": {
                        symbol = "and";
                        break;
                    }
                    case "||": {
                        symbol = "or";
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(String.valueOf(binaryOperator));
                    }
                }
            } else if (expression instanceof Add || expression instanceof Divide || expression instanceof Multiply || expression instanceof Subtract) {
                BinaryArithmetic binaryArithmetic = (BinaryArithmetic)binaryOperator;
                switch (symbol) {
                    case "+": 
                    case "/": 
                    case "*": 
                    case "-": {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(String.valueOf(binaryArithmetic));
                    }
                }
            } else if (expression instanceof EqualTo || expression instanceof GreaterThan || expression instanceof GreaterThanOrEqual || expression instanceof LessThan || expression instanceof LessThanOrEqual) {
                BinaryComparison binaryComparison = (BinaryComparison)binaryOperator;
                switch (symbol) {
                    case "=": {
                        symbol = "equal";
                        break;
                    }
                    case ">": {
                        symbol = "greaterThan";
                        break;
                    }
                    case ">=": {
                        symbol = "greaterOrEqual";
                        break;
                    }
                    case "<": {
                        symbol = "lessThan";
                        break;
                    }
                    case "<=": {
                        symbol = "lessOrEqual";
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(String.valueOf(binaryComparison));
                    }
                }
            } else {
                throw new IllegalArgumentException(String.valueOf(binaryOperator));
            }
            return PMMLUtil.createApply((String)symbol, (Expression[])new Expression[]{ExpressionTranslator.translateInternal(left), ExpressionTranslator.translateInternal(right)});
        }
        if (expression instanceof CaseWhen) {
            CaseWhen caseWhen = (CaseWhen)expression;
            List branches = JavaConversions.seqAsJavaList((Seq)caseWhen.branches());
            Option elseValue = caseWhen.elseValue();
            Apply apply = null;
            Iterator branchIt = branches.iterator();
            Apply prevBranchApply = null;
            do {
                Tuple2 branch = (Tuple2)branchIt.next();
                org.apache.spark.sql.catalyst.expressions.Expression predicate = (org.apache.spark.sql.catalyst.expressions.Expression)branch._1();
                org.apache.spark.sql.catalyst.expressions.Expression value = (org.apache.spark.sql.catalyst.expressions.Expression)branch._2();
                Apply branchApply = PMMLUtil.createApply((String)"if", (Expression[])new Expression[0]).addExpressions(new Expression[]{ExpressionTranslator.translateInternal(predicate), ExpressionTranslator.translateInternal(value)});
                if (apply == null) {
                    apply = branchApply;
                }
                if (prevBranchApply != null) {
                    prevBranchApply.addExpressions(new Expression[]{branchApply});
                }
                prevBranchApply = branchApply;
            } while (branchIt.hasNext());
            if (elseValue.isDefined()) {
                org.apache.spark.sql.catalyst.expressions.Expression value = (org.apache.spark.sql.catalyst.expressions.Expression)elseValue.get();
                prevBranchApply.addExpressions(new Expression[]{ExpressionTranslator.translateInternal(value)});
            }
            return apply;
        }
        if (expression instanceof Cast) {
            Cast cast = (Cast)expression;
            org.apache.spark.sql.catalyst.expressions.Expression child = cast.child();
            DataType dataType = DatasetUtil.translateDataType(cast.dataType());
            Expression pmmlExpression = ExpressionTranslator.translateInternal(child);
            if (pmmlExpression instanceof HasDataType) {
                HasDataType hasDataType = (HasDataType)pmmlExpression;
                hasDataType.setDataType(dataType);
                return pmmlExpression;
            }
            throw new IllegalArgumentException(String.valueOf(cast));
        }
        if (expression instanceof If) {
            If _if = (If)expression;
            org.apache.spark.sql.catalyst.expressions.Expression predicate = _if.predicate();
            org.apache.spark.sql.catalyst.expressions.Expression trueValue = _if.trueValue();
            org.apache.spark.sql.catalyst.expressions.Expression falseValue = _if.falseValue();
            return PMMLUtil.createApply((String)"if", (Expression[])new Expression[]{ExpressionTranslator.translateInternal(predicate)}).addExpressions(new Expression[]{ExpressionTranslator.translateInternal(trueValue), ExpressionTranslator.translateInternal(falseValue)});
        }
        if (expression instanceof In) {
            In in = (In)expression;
            org.apache.spark.sql.catalyst.expressions.Expression value = in.value();
            List elements = JavaConversions.seqAsJavaList((Seq)in.list());
            Apply apply = PMMLUtil.createApply((String)"isIn", (Expression[])new Expression[]{ExpressionTranslator.translateInternal(value)});
            for (org.apache.spark.sql.catalyst.expressions.Expression element : elements) {
                apply.addExpressions(new Expression[]{ExpressionTranslator.translateInternal(element)});
            }
            return apply;
        }
        if (expression instanceof Literal) {
            Literal literal = (Literal)expression;
            Object value = literal.value();
            DataType dataType = DatasetUtil.translateDataType(literal.dataType());
            return PMMLUtil.createConstant((Object)value, (DataType)dataType);
        }
        if (expression instanceof Not) {
            Not not = (Not)expression;
            org.apache.spark.sql.catalyst.expressions.Expression child = not.child();
            return PMMLUtil.createApply((String)"not", (Expression[])new Expression[]{ExpressionTranslator.translateInternal(child)});
        }
        if (expression instanceof UnaryExpression) {
            UnaryExpression unaryExpression = (UnaryExpression)expression;
            org.apache.spark.sql.catalyst.expressions.Expression child = unaryExpression.child();
            if (expression instanceof IsNotNull) {
                return PMMLUtil.createApply((String)"isNotMissing", (Expression[])new Expression[]{ExpressionTranslator.translateInternal(child)});
            }
            if (expression instanceof IsNull) {
                return PMMLUtil.createApply((String)"isMissing", (Expression[])new Expression[]{ExpressionTranslator.translateInternal(child)});
            }
            if (expression instanceof UnaryMinus) {
                UnaryMinus unaryMinus = (UnaryMinus)unaryExpression;
                Expression pmmlExpression = ExpressionTranslator.translateInternal(child);
                if (pmmlExpression instanceof Constant) {
                    Constant constant = (Constant)pmmlExpression;
                    constant.setValue("-" + constant.getValue());
                    return constant;
                }
                return PMMLUtil.createApply((String)"*", (Expression[])new Expression[]{PMMLUtil.createConstant((Number)-1), pmmlExpression});
            }
            throw new IllegalArgumentException(String.valueOf(unaryExpression));
        }
        throw new IllegalArgumentException(String.valueOf(expression));
    }
}

