/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.feature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.spark.ml.feature.StringIndexerModel;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Field;
import org.dmg.pmml.InvalidValueTreatmentMethod;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.Decorator;
import org.jpmml.converter.Feature;
import org.jpmml.converter.InvalidValueDecorator;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.sparkml.FeatureConverter;
import org.jpmml.sparkml.SparkMLEncoder;

public class StringIndexerModelConverter
extends FeatureConverter<StringIndexerModel> {
    public StringIndexerModelConverter(StringIndexerModel transformer) {
        super(transformer);
    }

    @Override
    public List<Feature> encodeFeatures(SparkMLEncoder encoder) {
        StringIndexerModel transformer = (StringIndexerModel)this.getTransformer();
        Feature feature = encoder.getOnlyFeature(transformer.getInputCol());
        ArrayList<String> categories = new ArrayList<String>();
        categories.addAll(Arrays.asList(transformer.labels()));
        Field field = encoder.toCategorical(feature.getName(), categories);
        if (field instanceof DataField) {
            InvalidValueTreatmentMethod invalidValueTreatmentMethod;
            String handleInvalid;
            DataField dataField = (DataField)field;
            switch (handleInvalid = transformer.getHandleInvalid()) {
                case "error": {
                    invalidValueTreatmentMethod = InvalidValueTreatmentMethod.RETURN_INVALID;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(handleInvalid);
                }
            }
            InvalidValueDecorator invalidValueDecorator = new InvalidValueDecorator().setInvalidValueTreatment(invalidValueTreatmentMethod);
            encoder.addDecorator(dataField.getName(), (Decorator)invalidValueDecorator);
        } else if (!(field instanceof DerivedField)) {
            throw new IllegalArgumentException();
        }
        return Collections.singletonList(new CategoricalFeature((PMMLEncoder)encoder, field, categories));
    }
}

