/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.classification.DecisionTreeClassificationModel;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel;
import org.apache.spark.ml.tree.CategoricalSplit;
import org.apache.spark.ml.tree.ContinuousSplit;
import org.apache.spark.ml.tree.DecisionTreeModel;
import org.apache.spark.ml.tree.InternalNode;
import org.apache.spark.ml.tree.LeafNode;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.tree.Split;
import org.apache.spark.ml.tree.TreeEnsembleModel;
import org.apache.spark.mllib.tree.impurity.ImpurityCalculator;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.ScoreDistribution;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.True;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.BooleanFeature;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PredicateManager;
import org.jpmml.converter.Schema;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sparkml.TreeModelOptions;
import org.jpmml.sparkml.visitors.TreeModelCompactor;

public class TreeModelUtil {
    private static final double[] TRUE = new double[]{1.0};
    private static final double[] FALSE = new double[]{0.0};

    private TreeModelUtil() {
    }

    public static <M extends Model<M>, T extends Model<T>> List<TreeModel> encodeDecisionTreeEnsemble(M model, Schema schema) {
        PredicateManager predicateManager = new PredicateManager();
        return TreeModelUtil.encodeDecisionTreeEnsemble(model, predicateManager, schema);
    }

    public static <M extends Model<M>, T extends Model<T>> List<TreeModel> encodeDecisionTreeEnsemble(M model, PredicateManager predicateManager, Schema schema) {
        Model[] trees;
        Schema segmentSchema = schema.toAnonymousSchema();
        ArrayList<TreeModel> treeModels = new ArrayList<TreeModel>();
        for (Model tree : trees = (Model[])((TreeEnsembleModel)model).trees()) {
            TreeModel treeModel = TreeModelUtil.encodeDecisionTree(tree, predicateManager, segmentSchema);
            treeModels.add(treeModel);
        }
        return treeModels;
    }

    public static <M extends Model<M>> TreeModel encodeDecisionTree(M model, Schema schema) {
        PredicateManager predicateManager = new PredicateManager();
        return TreeModelUtil.encodeDecisionTree(model, predicateManager, schema);
    }

    public static <M extends Model<M>> TreeModel encodeDecisionTree(M model, PredicateManager predicateManager, Schema schema) {
        Node node = ((DecisionTreeModel)model).rootNode();
        if (model instanceof DecisionTreeRegressionModel) {
            return TreeModelUtil.encodeTreeModel(node, predicateManager, MiningFunction.REGRESSION, schema);
        }
        if (model instanceof DecisionTreeClassificationModel) {
            return TreeModelUtil.encodeTreeModel(node, predicateManager, MiningFunction.CLASSIFICATION, schema);
        }
        throw new IllegalArgumentException();
    }

    public static TreeModel encodeTreeModel(Node node, PredicateManager predicateManager, MiningFunction miningFunction, Schema schema) {
        org.dmg.pmml.tree.Node root = TreeModelUtil.encodeNode(node, predicateManager, Collections.emptyMap(), miningFunction, schema).setPredicate((Predicate)new True());
        TreeModel treeModel = new TreeModel(miningFunction, ModelUtil.createMiningSchema((Label)schema.getLabel()), root).setSplitCharacteristic(TreeModel.SplitCharacteristic.BINARY_SPLIT);
        String compact = TreeModelOptions.COMPACT;
        if (compact != null && Boolean.valueOf(compact).booleanValue()) {
            TreeModelCompactor visitor = new TreeModelCompactor();
            visitor.applyTo((Visitable)treeModel);
        }
        return treeModel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static org.dmg.pmml.tree.Node encodeNode(Node node, PredicateManager predicateManager, Map<FieldName, Set<String>> parentFieldValues, MiningFunction miningFunction, Schema schema) {
        if (node instanceof InternalNode) {
            Predicate rightPredicate;
            Predicate leftPredicate;
            InternalNode internalNode = (InternalNode)node;
            Map<FieldName, Set<String>> leftFieldValues = parentFieldValues;
            Map<FieldName, Set<String>> rightFieldValues = parentFieldValues;
            Split split = internalNode.split();
            Feature feature = schema.getFeature(split.featureIndex());
            if (split instanceof ContinuousSplit) {
                ContinuousSplit continuousSplit = (ContinuousSplit)split;
                double threshold = continuousSplit.threshold();
                if (feature instanceof BooleanFeature) {
                    BooleanFeature booleanFeature = (BooleanFeature)feature;
                    if (threshold != 0.0) {
                        throw new IllegalArgumentException();
                    }
                    leftPredicate = predicateManager.createSimplePredicate((Feature)booleanFeature, SimplePredicate.Operator.EQUAL, booleanFeature.getValue(0));
                    rightPredicate = predicateManager.createSimplePredicate((Feature)booleanFeature, SimplePredicate.Operator.EQUAL, booleanFeature.getValue(1));
                } else {
                    ContinuousFeature continuousFeature = feature.toContinuousFeature();
                    String value = ValueUtil.formatValue((Number)threshold);
                    leftPredicate = predicateManager.createSimplePredicate((Feature)continuousFeature, SimplePredicate.Operator.LESS_OR_EQUAL, value);
                    rightPredicate = predicateManager.createSimplePredicate((Feature)continuousFeature, SimplePredicate.Operator.GREATER_THAN, value);
                }
            } else {
                if (!(split instanceof CategoricalSplit)) throw new IllegalArgumentException();
                CategoricalSplit categoricalSplit = (CategoricalSplit)split;
                double[] leftCategories = categoricalSplit.leftCategories();
                double[] rightCategories = categoricalSplit.rightCategories();
                if (feature instanceof BinaryFeature) {
                    SimplePredicate.Operator rightOperator;
                    SimplePredicate.Operator leftOperator;
                    BinaryFeature binaryFeature = (BinaryFeature)feature;
                    if (Arrays.equals(TRUE, leftCategories) && Arrays.equals(FALSE, rightCategories)) {
                        leftOperator = SimplePredicate.Operator.EQUAL;
                        rightOperator = SimplePredicate.Operator.NOT_EQUAL;
                    } else {
                        if (!Arrays.equals(FALSE, leftCategories) || !Arrays.equals(TRUE, rightCategories)) throw new IllegalArgumentException();
                        leftOperator = SimplePredicate.Operator.NOT_EQUAL;
                        rightOperator = SimplePredicate.Operator.EQUAL;
                    }
                    String value = ValueUtil.formatValue((Object)binaryFeature.getValue());
                    leftPredicate = predicateManager.createSimplePredicate((Feature)binaryFeature, leftOperator, value);
                    rightPredicate = predicateManager.createSimplePredicate((Feature)binaryFeature, rightOperator, value);
                } else {
                    if (!(feature instanceof CategoricalFeature)) throw new IllegalArgumentException();
                    CategoricalFeature categoricalFeature = (CategoricalFeature)feature;
                    FieldName name = categoricalFeature.getName();
                    List values = categoricalFeature.getValues();
                    if (values.size() != leftCategories.length + rightCategories.length) {
                        throw new IllegalArgumentException();
                    }
                    final Set<String> parentValues = parentFieldValues.get(name);
                    com.google.common.base.Predicate<String> valueFilter = new com.google.common.base.Predicate<String>(){

                        public boolean apply(String value) {
                            if (parentValues != null) {
                                return parentValues.contains(value);
                            }
                            return true;
                        }
                    };
                    List<String> leftValues = TreeModelUtil.selectValues(values, leftCategories, valueFilter);
                    List<String> rightValues = TreeModelUtil.selectValues(values, rightCategories, valueFilter);
                    leftFieldValues = new HashMap<FieldName, Set<String>>(parentFieldValues);
                    leftFieldValues.put(name, new HashSet<String>(leftValues));
                    rightFieldValues = new HashMap<FieldName, Set<String>>(parentFieldValues);
                    rightFieldValues.put(name, new HashSet<String>(rightValues));
                    leftPredicate = predicateManager.createSimpleSetPredicate((Feature)categoricalFeature, leftValues);
                    rightPredicate = predicateManager.createSimpleSetPredicate((Feature)categoricalFeature, rightValues);
                }
            }
            org.dmg.pmml.tree.Node result = new org.dmg.pmml.tree.Node();
            org.dmg.pmml.tree.Node leftChild = TreeModelUtil.encodeNode(internalNode.leftChild(), predicateManager, leftFieldValues, miningFunction, schema).setPredicate(leftPredicate);
            org.dmg.pmml.tree.Node rightChild = TreeModelUtil.encodeNode(internalNode.rightChild(), predicateManager, rightFieldValues, miningFunction, schema).setPredicate(rightPredicate);
            result.addNodes(new org.dmg.pmml.tree.Node[]{leftChild, rightChild});
            return result;
        }
        if (!(node instanceof LeafNode)) throw new IllegalArgumentException();
        LeafNode leafNode = (LeafNode)node;
        org.dmg.pmml.tree.Node result = new org.dmg.pmml.tree.Node();
        switch (miningFunction) {
            case REGRESSION: {
                String score = ValueUtil.formatValue((Number)node.prediction());
                result.setScore(score);
                return result;
            }
            case CLASSIFICATION: {
                CategoricalLabel categoricalLabel = (CategoricalLabel)schema.getLabel();
                int index = ValueUtil.asInt((Number)node.prediction());
                result.setScore(categoricalLabel.getValue(index));
                ImpurityCalculator impurityCalculator = node.impurityStats();
                result.setRecordCount(Double.valueOf(impurityCalculator.count()));
                double[] stats = impurityCalculator.stats();
                for (int i = 0; i < stats.length; ++i) {
                    ScoreDistribution scoreDistribution = new ScoreDistribution(categoricalLabel.getValue(i), stats[i]);
                    result.addScoreDistributions(new ScoreDistribution[]{scoreDistribution});
                }
                return result;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static List<String> selectValues(List<String> values, double[] categories, com.google.common.base.Predicate<String> valueFilter) {
        if (categories.length == 1) {
            int index = ValueUtil.asInt((Number)categories[0]);
            String value = values.get(index);
            if (valueFilter.apply((Object)value)) {
                return Collections.singletonList(value);
            }
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(categories.length);
        for (int i = 0; i < categories.length; ++i) {
            int index = ValueUtil.asInt((Number)categories[i]);
            String value = values.get(index);
            if (!valueFilter.apply((Object)value)) continue;
            result.add(value);
        }
        return result;
    }
}

