/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.feature;

import java.util.Collections;
import java.util.List;
import org.apache.spark.ml.feature.StopWordsRemover;
import org.jpmml.converter.Feature;
import org.jpmml.sparkml.DocumentFeature;
import org.jpmml.sparkml.FeatureConverter;
import org.jpmml.sparkml.SparkMLEncoder;
import org.jpmml.sparkml.TermUtil;

public class StopWordsRemoverConverter
extends FeatureConverter<StopWordsRemover> {
    public StopWordsRemoverConverter(StopWordsRemover transformer) {
        super(transformer);
    }

    @Override
    public List<Feature> encodeFeatures(SparkMLEncoder encoder) {
        String[] stopWords;
        StopWordsRemover transformer = (StopWordsRemover)this.getTransformer();
        DocumentFeature documentFeature = (DocumentFeature)encoder.getOnlyFeature(transformer.getInputCol());
        DocumentFeature.StopWordSet stopWordSet = new DocumentFeature.StopWordSet(transformer.getCaseSensitive());
        for (String stopWord : stopWords = transformer.getStopWords()) {
            if (TermUtil.hasPunctuation(stopWord)) {
                throw new IllegalArgumentException(stopWord);
            }
            stopWordSet.add(stopWord);
        }
        documentFeature.addStopWordSet(stopWordSet);
        return Collections.singletonList(documentFeature);
    }
}

