/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml;

import java.util.ArrayList;
import java.util.List;
import org.apache.spark.ml.PredictionModel;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.shared.HasFeaturesCol;
import org.apache.spark.ml.param.shared.HasProbabilityCol;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.OpType;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.ResultFeature;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.sparkml.ModelConverter;
import org.jpmml.sparkml.SparkMLEncoder;

public abstract class ClassificationModelConverter<T extends PredictionModel<Vector, T> & HasFeaturesCol>
extends ModelConverter<T> {
    public ClassificationModelConverter(T model) {
        super(model);
    }

    @Override
    public MiningFunction getMiningFunction() {
        return MiningFunction.CLASSIFICATION;
    }

    @Override
    public List<OutputField> registerOutputFields(Label label, SparkMLEncoder encoder) {
        PredictionModel model = (PredictionModel)this.getTransformer();
        CategoricalLabel categoricalLabel = (CategoricalLabel)label;
        ArrayList<String> categories = new ArrayList<String>();
        for (int i = 0; i < categoricalLabel.size(); ++i) {
            String category = String.valueOf(i);
            categories.add(category);
        }
        ArrayList<OutputField> result = new ArrayList<OutputField>();
        String predictionCol = model.getPredictionCol();
        OutputField pmmlPredictedField = ModelUtil.createPredictedField((FieldName)FieldName.create((String)("pmml(" + predictionCol + ")")), (DataType)categoricalLabel.getDataType(), (OpType)OpType.CATEGORICAL);
        result.add(pmmlPredictedField);
        MapValues mapValues = PMMLUtil.createMapValues((FieldName)pmmlPredictedField.getName(), (List)categoricalLabel.getValues(), categories);
        OutputField predictedField = new OutputField(FieldName.create((String)predictionCol), DataType.DOUBLE).setOpType(OpType.CATEGORICAL).setResultFeature(ResultFeature.TRANSFORMED_VALUE).setExpression((Expression)mapValues);
        result.add(predictedField);
        CategoricalFeature feature = new CategoricalFeature((PMMLEncoder)encoder, (Field)predictedField, categories){

            public ContinuousFeature toContinuousFeature() {
                PMMLEncoder encoder = this.ensureEncoder();
                return new ContinuousFeature(encoder, (Feature)this);
            }
        };
        encoder.putOnlyFeature(predictionCol, (Feature)feature);
        if (model instanceof HasProbabilityCol) {
            HasProbabilityCol hasProbabilityCol = (HasProbabilityCol)model;
            String probabilityCol = hasProbabilityCol.getProbabilityCol();
            ArrayList<Feature> features = new ArrayList<Feature>();
            for (int i = 0; i < categoricalLabel.size(); ++i) {
                String value = categoricalLabel.getValue(i);
                OutputField probabilityField = ModelUtil.createProbabilityField((FieldName)FieldName.create((String)(probabilityCol + "(" + value + ")")), (DataType)DataType.DOUBLE, (String)value);
                result.add(probabilityField);
                features.add((Feature)new ContinuousFeature((PMMLEncoder)encoder, (Field)probabilityField));
            }
            encoder.putFeatures(probabilityCol, features);
        }
        return result;
    }
}

