/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml;

import java.util.List;
import java.util.Objects;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Label;
import org.jpmml.converter.Schema;

public class SchemaUtil {
    private SchemaUtil() {
    }

    public static void checkSchema(Schema schema) {
        Label label = schema.getLabel();
        List features = schema.getFeatures();
        if (label != null) {
            for (Feature feature : features) {
                if (!Objects.equals(label.getName(), feature.getName())) continue;
                throw new IllegalArgumentException("Label column '" + label.getName() + "' is contained in the list of feature columns");
            }
        }
    }

    public static void checkSize(int size, CategoricalLabel categoricalLabel) {
        if (categoricalLabel.size() != size) {
            throw new IllegalArgumentException("Expected " + size + " target categories, got " + categoricalLabel.size() + " target categories");
        }
    }

    public static void checkSize(int size, List<? extends Feature> features) {
        if (features.size() != size) {
            throw new IllegalArgumentException("Expected " + size + " feature(s), got " + features.size() + " feature(s)");
        }
    }
}

