/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml;

import java.util.ArrayList;
import java.util.List;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.OpType;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.ResultFeature;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Label;
import org.jpmml.converter.LabelUtil;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.sparkml.ModelConverter;
import org.jpmml.sparkml.SparkMLEncoder;

public abstract class ClusteringModelConverter<T extends Model<T> & HasPredictionCol>
extends ModelConverter<T> {
    public ClusteringModelConverter(T model) {
        super(model);
    }

    public abstract int getNumberOfClusters();

    @Override
    public MiningFunction getMiningFunction() {
        return MiningFunction.CLUSTERING;
    }

    @Override
    public List<OutputField> registerOutputFields(Label label, SparkMLEncoder encoder) {
        Model model = (Model)this.getTransformer();
        ArrayList<OutputField> result = new ArrayList<OutputField>();
        String predictionCol = ((HasPredictionCol)model).getPredictionCol();
        OutputField pmmlPredictedField = ModelUtil.createPredictedField((FieldName)FieldName.create((String)("pmml(" + predictionCol + ")")), (DataType)DataType.STRING, (OpType)OpType.CATEGORICAL).setFinalResult(Boolean.valueOf(false));
        result.add(pmmlPredictedField);
        final OutputField predictedField = new OutputField(FieldName.create((String)predictionCol), DataType.INTEGER).setOpType(OpType.CATEGORICAL).setResultFeature(ResultFeature.TRANSFORMED_VALUE).setExpression((Expression)new FieldRef(pmmlPredictedField.getName()));
        result.add(predictedField);
        List clusters = LabelUtil.createTargetCategories((int)this.getNumberOfClusters());
        CategoricalFeature feature = new CategoricalFeature((PMMLEncoder)encoder, (Field)predictedField, clusters){

            public ContinuousFeature toContinuousFeature() {
                PMMLEncoder encoder = this.ensureEncoder();
                return new ContinuousFeature(encoder, (Field)predictedField);
            }
        };
        encoder.putOnlyFeature(predictionCol, (Feature)feature);
        return result;
    }
}

