/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.spark.ml.classification.DecisionTreeClassificationModel;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel;
import org.apache.spark.ml.tree.CategoricalSplit;
import org.apache.spark.ml.tree.ContinuousSplit;
import org.apache.spark.ml.tree.DecisionTreeModel;
import org.apache.spark.ml.tree.InternalNode;
import org.apache.spark.ml.tree.LeafNode;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.tree.Split;
import org.apache.spark.ml.tree.TreeEnsembleModel;
import org.apache.spark.mllib.tree.impurity.ImpurityCalculator;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.ScoreDistribution;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.True;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.BooleanFeature;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PredicateManager;
import org.jpmml.converter.Schema;
import org.jpmml.converter.ValueUtil;

public class TreeModelUtil {
    private static final double[] TRUE = new double[]{1.0};
    private static final double[] FALSE = new double[]{0.0};

    private TreeModelUtil() {
    }

    public static List<TreeModel> encodeDecisionTreeEnsemble(TreeEnsembleModel<?> model, Schema schema) {
        PredicateManager predicateManager = new PredicateManager();
        return TreeModelUtil.encodeDecisionTreeEnsemble(model, predicateManager, schema);
    }

    public static List<TreeModel> encodeDecisionTreeEnsemble(TreeEnsembleModel<?> model, PredicateManager predicateManager, Schema schema) {
        DecisionTreeModel[] trees;
        Schema segmentSchema = schema.toAnonymousSchema();
        ArrayList<TreeModel> treeModels = new ArrayList<TreeModel>();
        for (DecisionTreeModel tree : trees = model.trees()) {
            TreeModel treeModel = TreeModelUtil.encodeDecisionTree(tree, predicateManager, segmentSchema);
            treeModels.add(treeModel);
        }
        return treeModels;
    }

    public static TreeModel encodeDecisionTree(DecisionTreeModel model, Schema schema) {
        PredicateManager predicateManager = new PredicateManager();
        return TreeModelUtil.encodeDecisionTree(model, predicateManager, schema);
    }

    public static TreeModel encodeDecisionTree(DecisionTreeModel model, PredicateManager predicateManager, Schema schema) {
        Node node = model.rootNode();
        if (model instanceof DecisionTreeRegressionModel) {
            return TreeModelUtil.encodeTreeModel(node, predicateManager, MiningFunction.REGRESSION, schema);
        }
        if (model instanceof DecisionTreeClassificationModel) {
            return TreeModelUtil.encodeTreeModel(node, predicateManager, MiningFunction.CLASSIFICATION, schema);
        }
        throw new IllegalArgumentException();
    }

    public static TreeModel encodeTreeModel(Node node, PredicateManager predicateManager, MiningFunction miningFunction, Schema schema) {
        org.dmg.pmml.tree.Node root = TreeModelUtil.encodeNode(node, predicateManager, miningFunction, schema).setPredicate((Predicate)new True());
        TreeModel treeModel = new TreeModel(miningFunction, ModelUtil.createMiningSchema((Label)schema.getLabel()), root).setSplitCharacteristic(TreeModel.SplitCharacteristic.BINARY_SPLIT);
        return treeModel;
    }

    public static org.dmg.pmml.tree.Node encodeNode(Node node, PredicateManager predicateManager, MiningFunction miningFunction, Schema schema) {
        if (node instanceof InternalNode) {
            return TreeModelUtil.encodeInternalNode((InternalNode)node, predicateManager, miningFunction, schema);
        }
        if (node instanceof LeafNode) {
            return TreeModelUtil.encodeLeafNode((LeafNode)node, miningFunction, schema);
        }
        throw new IllegalArgumentException();
    }

    private static org.dmg.pmml.tree.Node encodeInternalNode(InternalNode internalNode, PredicateManager predicateManager, MiningFunction miningFunction, Schema schema) {
        org.dmg.pmml.tree.Node result = TreeModelUtil.createNode((Node)internalNode, miningFunction, schema);
        Predicate[] predicates = TreeModelUtil.encodeSplit(internalNode.split(), predicateManager, schema);
        org.dmg.pmml.tree.Node leftChild = TreeModelUtil.encodeNode(internalNode.leftChild(), predicateManager, miningFunction, schema).setPredicate(predicates[0]);
        org.dmg.pmml.tree.Node rightChild = TreeModelUtil.encodeNode(internalNode.rightChild(), predicateManager, miningFunction, schema).setPredicate(predicates[1]);
        result.addNodes(new org.dmg.pmml.tree.Node[]{leftChild, rightChild});
        return result;
    }

    private static org.dmg.pmml.tree.Node encodeLeafNode(LeafNode leafNode, MiningFunction miningFunction, Schema schema) {
        org.dmg.pmml.tree.Node result = TreeModelUtil.createNode((Node)leafNode, miningFunction, schema);
        return result;
    }

    private static org.dmg.pmml.tree.Node createNode(Node node, MiningFunction miningFunction, Schema schema) {
        org.dmg.pmml.tree.Node result = new org.dmg.pmml.tree.Node();
        switch (miningFunction) {
            case REGRESSION: {
                String score = ValueUtil.formatValue((Number)node.prediction());
                result.setScore(score);
                break;
            }
            case CLASSIFICATION: {
                CategoricalLabel categoricalLabel = (CategoricalLabel)schema.getLabel();
                int index = ValueUtil.asInt((Number)node.prediction());
                result.setScore(categoricalLabel.getValue(index));
                ImpurityCalculator impurityCalculator = node.impurityStats();
                result.setRecordCount(Double.valueOf(impurityCalculator.count()));
                double[] stats = impurityCalculator.stats();
                for (int i = 0; i < stats.length; ++i) {
                    if (stats[i] == 0.0) continue;
                    ScoreDistribution scoreDistribution = new ScoreDistribution(categoricalLabel.getValue(i), stats[i]);
                    result.addScoreDistributions(new ScoreDistribution[]{scoreDistribution});
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return result;
    }

    private static Predicate[] encodeSplit(Split split, PredicateManager predicateManager, Schema schema) {
        if (split instanceof ContinuousSplit) {
            return TreeModelUtil.encodeContinuousSplit((ContinuousSplit)split, predicateManager, schema);
        }
        if (split instanceof CategoricalSplit) {
            return TreeModelUtil.encodeCategoricalSplit((CategoricalSplit)split, predicateManager, schema);
        }
        throw new IllegalArgumentException();
    }

    private static Predicate[] encodeContinuousSplit(ContinuousSplit continuousSplit, PredicateManager predicateManager, Schema schema) {
        Predicate rightPredicate;
        Predicate leftPredicate;
        Feature feature = schema.getFeature(continuousSplit.featureIndex());
        double threshold = continuousSplit.threshold();
        if (feature instanceof BooleanFeature) {
            BooleanFeature booleanFeature = (BooleanFeature)feature;
            if (threshold != 0.0) {
                throw new IllegalArgumentException();
            }
            leftPredicate = predicateManager.createSimplePredicate((Feature)booleanFeature, SimplePredicate.Operator.EQUAL, booleanFeature.getValue(0));
            rightPredicate = predicateManager.createSimplePredicate((Feature)booleanFeature, SimplePredicate.Operator.EQUAL, booleanFeature.getValue(1));
        } else {
            ContinuousFeature continuousFeature = feature.toContinuousFeature();
            String value = ValueUtil.formatValue((Number)threshold);
            leftPredicate = predicateManager.createSimplePredicate((Feature)continuousFeature, SimplePredicate.Operator.LESS_OR_EQUAL, value);
            rightPredicate = predicateManager.createSimplePredicate((Feature)continuousFeature, SimplePredicate.Operator.GREATER_THAN, value);
        }
        return new Predicate[]{leftPredicate, rightPredicate};
    }

    private static Predicate[] encodeCategoricalSplit(CategoricalSplit categoricalSplit, PredicateManager predicateManager, Schema schema) {
        Predicate rightPredicate;
        Predicate leftPredicate;
        Feature feature = schema.getFeature(categoricalSplit.featureIndex());
        double[] leftCategories = categoricalSplit.leftCategories();
        double[] rightCategories = categoricalSplit.rightCategories();
        if (feature instanceof BinaryFeature) {
            SimplePredicate.Operator rightOperator;
            SimplePredicate.Operator leftOperator;
            BinaryFeature binaryFeature = (BinaryFeature)feature;
            if (Arrays.equals(TRUE, leftCategories) && Arrays.equals(FALSE, rightCategories)) {
                leftOperator = SimplePredicate.Operator.EQUAL;
                rightOperator = SimplePredicate.Operator.NOT_EQUAL;
            } else if (Arrays.equals(FALSE, leftCategories) && Arrays.equals(TRUE, rightCategories)) {
                leftOperator = SimplePredicate.Operator.NOT_EQUAL;
                rightOperator = SimplePredicate.Operator.EQUAL;
            } else {
                throw new IllegalArgumentException();
            }
            String value = ValueUtil.formatValue((Object)binaryFeature.getValue());
            leftPredicate = predicateManager.createSimplePredicate((Feature)binaryFeature, leftOperator, value);
            rightPredicate = predicateManager.createSimplePredicate((Feature)binaryFeature, rightOperator, value);
        } else if (feature instanceof CategoricalFeature) {
            CategoricalFeature categoricalFeature = (CategoricalFeature)feature;
            List values = categoricalFeature.getValues();
            if (values.size() != leftCategories.length + rightCategories.length) {
                throw new IllegalArgumentException();
            }
            List<String> leftValues = TreeModelUtil.getValues(categoricalFeature, leftCategories);
            List<String> rightValues = TreeModelUtil.getValues(categoricalFeature, rightCategories);
            leftPredicate = predicateManager.createSimpleSetPredicate((Feature)categoricalFeature, leftValues);
            rightPredicate = predicateManager.createSimpleSetPredicate((Feature)categoricalFeature, rightValues);
        } else {
            throw new IllegalArgumentException();
        }
        return new Predicate[]{leftPredicate, rightPredicate};
    }

    private static List<String> getValues(CategoricalFeature categoricalFeature, double[] categories) {
        if (categories.length == 1) {
            int index = ValueUtil.asInt((Number)categories[0]);
            String value = categoricalFeature.getValue(index);
            return Collections.singletonList(value);
        }
        ArrayList<String> result = new ArrayList<String>(categories.length);
        for (int i = 0; i < categories.length; ++i) {
            int index = ValueUtil.asInt((Number)categories[i]);
            String value = categoricalFeature.getValue(index);
            result.add(value);
        }
        return result;
    }
}

