/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.feature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.spark.ml.feature.StringIndexerModel;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.InvalidValueTreatmentMethod;
import org.dmg.pmml.OpType;
import org.dmg.pmml.TypeDefinitionField;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.Decorator;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureUtil;
import org.jpmml.converter.InvalidValueDecorator;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.sparkml.FeatureConverter;
import org.jpmml.sparkml.SparkMLEncoder;

public class StringIndexerModelConverter
extends FeatureConverter<StringIndexerModel> {
    private static final String LABEL_UNKNOWN = "__unknown";

    public StringIndexerModelConverter(StringIndexerModel transformer) {
        super(transformer);
    }

    @Override
    public List<Feature> encodeFeatures(SparkMLEncoder encoder) {
        StringIndexerModel transformer = (StringIndexerModel)this.getTransformer();
        Feature feature = encoder.getOnlyFeature(transformer.getInputCol());
        ArrayList<String> categories = new ArrayList<String>();
        categories.addAll(Arrays.asList(transformer.labels()));
        String handleInvalid = transformer.getHandleInvalid();
        TypeDefinitionField field = encoder.toCategorical(feature.getName(), categories);
        if (field instanceof DataField) {
            InvalidValueTreatmentMethod invalidValueTreatmentMethod;
            DataField dataField = (DataField)field;
            switch (handleInvalid) {
                case "keep": {
                    invalidValueTreatmentMethod = InvalidValueTreatmentMethod.AS_IS;
                    break;
                }
                case "error": {
                    invalidValueTreatmentMethod = InvalidValueTreatmentMethod.RETURN_INVALID;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(handleInvalid);
                }
            }
            InvalidValueDecorator invalidValueDecorator = new InvalidValueDecorator().setInvalidValueTreatment(invalidValueTreatmentMethod);
            encoder.addDecorator(dataField.getName(), (Decorator)invalidValueDecorator);
        } else if (!(field instanceof DerivedField)) {
            throw new IllegalArgumentException();
        }
        switch (handleInvalid) {
            case "keep": {
                Apply setApply = PMMLUtil.createApply((String)"isIn", (Expression[])new Expression[]{feature.ref()});
                for (String category : categories) {
                    setApply.addExpressions(new Expression[]{PMMLUtil.createConstant((Object)category)});
                }
                categories.add(LABEL_UNKNOWN);
                Apply apply = PMMLUtil.createApply((String)"if", (Expression[])new Expression[]{setApply, feature.ref(), PMMLUtil.createConstant((Object)LABEL_UNKNOWN)});
                field = encoder.createDerivedField(FeatureUtil.createName((String)"handleInvalid", (Feature)feature), OpType.CATEGORICAL, feature.getDataType(), (Expression)apply);
                break;
            }
        }
        return Collections.singletonList(new CategoricalFeature((PMMLEncoder)encoder, field, categories));
    }
}

