/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.sql.types.StructType;
import org.dmg.pmml.PMML;
import org.jpmml.model.MetroJAXBUtil;
import org.jpmml.sparkml.ConverterUtil;

public class PMMLBuilder {
    private StructType schema = null;
    private PipelineModel pipelineModel = null;
    private Map<String, Map<String, Object>> options = new LinkedHashMap<String, Map<String, Object>>();

    public PMMLBuilder(StructType schema, PipelineModel pipelineModel) {
        this.setSchema(schema);
        this.setPipelineModel(pipelineModel);
    }

    public PMML build() {
        StructType schema = this.getSchema();
        PipelineModel pipelineModel = this.getPipelineModel();
        Map<String, Map<String, Object>> options = this.getOptions();
        return ConverterUtil.toPMML(schema, pipelineModel, options);
    }

    public byte[] buildByteArray() {
        PMML pmml = this.build();
        ByteArrayOutputStream os = new ByteArrayOutputStream(0x100000);
        try {
            MetroJAXBUtil.marshalPMML((PMML)pmml, (OutputStream)os);
        }
        catch (JAXBException je) {
            throw new RuntimeException(je);
        }
        return os.toByteArray();
    }

    public PMMLBuilder putOption(PipelineStage pipelineStage, String key, Object value) {
        return this.putOption(pipelineStage.uid(), key, value);
    }

    public PMMLBuilder putOptions(PipelineStage pipelineStage, Map<String, ?> map) {
        return this.putOptions(pipelineStage.uid(), map);
    }

    public PMMLBuilder putOption(String uid, String key, Object value) {
        return this.putOptions(uid, Collections.singletonMap(key, value));
    }

    public PMMLBuilder putOptions(String uid, Map<String, ?> map) {
        Map<String, Map<String, Object>> options = this.getOptions();
        Map<String, Object> pipelineStageOptions = options.get(uid);
        if (pipelineStageOptions == null) {
            pipelineStageOptions = new LinkedHashMap<String, Object>();
            options.put(uid, pipelineStageOptions);
        }
        pipelineStageOptions.putAll(map);
        return this;
    }

    public PMMLBuilder removeOptions(PipelineStage pipelineStage) {
        return this.removeOptions(pipelineStage.uid());
    }

    public PMMLBuilder removeOptions(String uid) {
        Map<String, Map<String, Object>> options = this.getOptions();
        options.remove(uid);
        return this;
    }

    public StructType getSchema() {
        return this.schema;
    }

    public PMMLBuilder setSchema(StructType schema) {
        if (schema == null) {
            throw new IllegalArgumentException();
        }
        this.schema = schema;
        return this;
    }

    public PipelineModel getPipelineModel() {
        return this.pipelineModel;
    }

    public PMMLBuilder setPipelineModel(PipelineModel pipelineModel) {
        if (pipelineModel == null) {
            throw new IllegalArgumentException();
        }
        this.pipelineModel = pipelineModel;
        return this;
    }

    public Map<String, Map<String, Object>> getOptions() {
        return this.options;
    }
}

