/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.model;

import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldColumnPair;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Row;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.DOMUtil;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sparkml.ModelConverter;

public class RegressionTableUtil {
    private RegressionTableUtil() {
    }

    public static <C extends ModelConverter<?>> void simplify(C converter, String identifier, List<Feature> features, List<Double> coefficients) {
        if (features.size() != coefficients.size()) {
            throw new IllegalArgumentException();
        }
        Integer lookupThreshold = (Integer)converter.getOption("lookup_threshold", null);
        if (lookupThreshold == null) {
            return;
        }
        Map<FieldName, Long> countMap = features.stream().filter(feature -> feature instanceof BinaryFeature).collect(Collectors.groupingBy(feature -> ((BinaryFeature)feature).getName(), Collectors.counting()));
        Set<Map.Entry<FieldName, Long>> entries = countMap.entrySet();
        for (Map.Entry entry : entries) {
            if ((Long)entry.getValue() < (long)lookupThreshold.intValue()) continue;
            RegressionTableUtil.createMapValues((FieldName)entry.getKey(), identifier, features, coefficients);
        }
    }

    private static MapValues createMapValues(FieldName name, String identifier, List<Feature> features, List<Double> coefficients) {
        DocumentBuilder documentBuilder = DOMUtil.createDocumentBuilder();
        InlineTable inlineTable = new InlineTable();
        List<String> columns = Arrays.asList("input", "output");
        ListIterator<Feature> featureIt = features.listIterator();
        ListIterator<Double> coefficientIt = coefficients.listIterator();
        PMMLEncoder encoder = null;
        while (featureIt.hasNext()) {
            BinaryFeature binaryFeature;
            Feature feature = featureIt.next();
            Double coefficient = coefficientIt.next();
            if (!(feature instanceof BinaryFeature) || !name.equals((Object)(binaryFeature = (BinaryFeature)feature).getName())) continue;
            featureIt.remove();
            coefficientIt.remove();
            if (encoder == null) {
                encoder = binaryFeature.getEncoder();
            }
            Row row = DOMUtil.createRow((DocumentBuilder)documentBuilder, columns, Arrays.asList(binaryFeature.getValue(), coefficient));
            inlineTable.addRows(new Row[]{row});
        }
        MapValues mapValues = new MapValues().addFieldColumnPairs(new FieldColumnPair[]{new FieldColumnPair(name, columns.get(0))}).setOutputColumn(columns.get(1)).setInlineTable(inlineTable).setDefaultValue(ValueUtil.formatValue((Number)0.0));
        DerivedField derivedField = encoder.createDerivedField(FieldName.create((String)("lookup(" + name.getValue() + (identifier != null ? ", " + identifier : "") + ")")), OpType.CONTINUOUS, DataType.DOUBLE, (Expression)mapValues);
        featureIt.add((Feature)new ContinuousFeature(encoder, (Field)derivedField));
        coefficientIt.add(1.0);
        return mapValues;
    }
}

