/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalog.Catalog;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructType;
import org.dmg.pmml.DataType;

public class DatasetUtil {
    private static final AtomicInteger ID = new AtomicInteger(1);

    private DatasetUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogicalPlan createAnalyzedLogicalPlan(SparkSession sparkSession, StructType schema, String statement) {
        String tableName = "sql2pmml_" + ID.getAndIncrement();
        statement = statement.replace("__THIS__", tableName);
        Dataset dataset = sparkSession.createDataFrame(Collections.emptyList(), schema);
        dataset.createOrReplaceTempView(tableName);
        try {
            QueryExecution queryExecution = sparkSession.sql(statement).queryExecution();
            LogicalPlan logicalPlan = queryExecution.analyzed();
            return logicalPlan;
        }
        finally {
            Catalog catalog = sparkSession.catalog();
            catalog.dropTempView(tableName);
        }
    }

    public static DataType translateDataType(org.apache.spark.sql.types.DataType sparkDataType) {
        if (sparkDataType instanceof StringType) {
            return DataType.STRING;
        }
        if (sparkDataType instanceof IntegralType) {
            return DataType.INTEGER;
        }
        if (sparkDataType instanceof DoubleType) {
            return DataType.DOUBLE;
        }
        if (sparkDataType instanceof BooleanType) {
            return DataType.BOOLEAN;
        }
        throw new IllegalArgumentException("Expected string, integral, double or boolean data type, got " + sparkDataType.typeName() + " data type");
    }
}

