/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.feature;

import java.util.ArrayList;
import java.util.List;
import org.apache.spark.ml.feature.OneHotEncoderModel;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.sparkml.BinarizedCategoricalFeature;
import org.jpmml.sparkml.FeatureConverter;
import org.jpmml.sparkml.SparkMLEncoder;
import org.jpmml.sparkml.feature.OneHotEncoderConverter;

public class OneHotEncoderModelConverter
extends FeatureConverter<OneHotEncoderModel> {
    public OneHotEncoderModelConverter(OneHotEncoderModel transformer) {
        super(transformer);
    }

    @Override
    public List<Feature> encodeFeatures(SparkMLEncoder encoder) {
        OneHotEncoderModel transformer = (OneHotEncoderModel)this.getTransformer();
        String[] inputCols = transformer.getInputCols();
        boolean dropLast = transformer.getDropLast();
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < inputCols.length; ++i) {
            CategoricalFeature categoricalFeature = (CategoricalFeature)encoder.getOnlyFeature(inputCols[i]);
            List values = categoricalFeature.getValues();
            List<Feature> binaryFeatures = OneHotEncoderConverter.encodeFeature((PMMLEncoder)encoder, (Feature)categoricalFeature, values, dropLast);
            result.add(new BinarizedCategoricalFeature((PMMLEncoder)encoder, categoricalFeature.getName(), categoricalFeature.getDataType(), binaryFeatures));
        }
        return result;
    }
}

