/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.SparkContext;
import org.apache.spark.ml.Transformer;
import org.jpmml.model.JAXBUtil;
import org.jpmml.sparkml.RegexKey;
import org.jpmml.sparkml.TransformerConverter;

public class ConverterFactory {
    private Map<RegexKey, ? extends Map<String, ?>> options = null;
    private static final int[] VERSION = new int[]{2, 3};
    private static final Map<Class<? extends Transformer>, Class<? extends TransformerConverter<?>>> converters = new LinkedHashMap();
    private static final Logger logger = LogManager.getLogger(ConverterFactory.class);

    public ConverterFactory(Map<RegexKey, ? extends Map<String, ?>> options) {
        this.setOptions(options);
    }

    public TransformerConverter<?> newConverter(Transformer transformer) {
        TransformerConverter converter;
        Class<?> clazz = transformer.getClass();
        Class<TransformerConverter<?>> converterClazz = converters.get(clazz);
        if (converterClazz == null) {
            throw new IllegalArgumentException("Transformer class " + clazz.getName() + " is not supported");
        }
        try {
            Constructor<TransformerConverter<?>> converterConstructor = converterClazz.getDeclaredConstructor(clazz);
            converter = converterConstructor.newInstance(transformer);
        }
        catch (ReflectiveOperationException roe) {
            throw new IllegalArgumentException("Transformer class " + clazz.getName() + " is not supported", roe);
        }
        if (converter != null) {
            Map<RegexKey, Map<String, ?>> options = this.getOptions();
            LinkedHashMap converterOptions = new LinkedHashMap();
            options.entrySet().stream().filter(entry -> ((RegexKey)entry.getKey()).test(transformer.uid())).map(entry -> (Map)entry.getValue()).forEach(converterOptions::putAll);
            converter.setOptions(converterOptions);
        }
        return converter;
    }

    public Map<RegexKey, ? extends Map<String, ?>> getOptions() {
        return this.options;
    }

    private void setOptions(Map<RegexKey, ? extends Map<String, ?>> options) {
        if (options == null) {
            throw new IllegalArgumentException();
        }
        this.options = options;
    }

    public static void checkVersion() {
        SparkContext sparkContext = SparkContext.getOrCreate();
        int[] version = ConverterFactory.parseVersion(sparkContext.version());
        if (!Arrays.equals(VERSION, version)) {
            throw new IllegalArgumentException("Expected Apache Spark ML version " + ConverterFactory.formatVersion(VERSION) + ", got version " + ConverterFactory.formatVersion(version) + " (" + sparkContext.version() + ")");
        }
    }

    public static void checkApplicationClasspath() {
        String string = "<PMML xmlns=\"http://www.dmg.org/PMML-4_4\"/>";
        try {
            JAXBUtil.unmarshalPMML((Source)new StreamSource(new StringReader(string)));
        }
        catch (JAXBException je) {
            throw new IllegalArgumentException("Expected JPMML-Model version 1.5.X, got a legacy version. See https://issues.apache.org/jira/browse/SPARK-15526", je);
        }
    }

    public static void checkNoShading() {
        Package _package = TransformerConverter.class.getPackage();
        String name = _package.getName();
        if (!name.equals("org.jpmml.sparkml")) {
            throw new IllegalArgumentException("Expected JPMML-SparkML converter classes to have package name prefix 'org.jpmml.sparkml', got package name prefix '" + name + "'");
        }
    }

    private static void init() {
        Enumeration<URL> urls;
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        try {
            urls = classLoader.getResources("META-INF/sparkml2pmml.properties");
        }
        catch (IOException ioe) {
            logger.warn((Object)"Failed to find resources", (Throwable)ioe);
            return;
        }
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            logger.trace((Object)("Loading resource " + url));
            try {
                InputStream is = url.openStream();
                Throwable throwable = null;
                try {
                    Properties properties = new Properties();
                    properties.load(is);
                    ConverterFactory.init(classLoader, properties);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (IOException ioe) {
                logger.warn((Object)"Failed to load resource", (Throwable)ioe);
            }
        }
    }

    private static void init(ClassLoader classLoader, Properties properties) {
        if (properties.isEmpty()) {
            return;
        }
        Set<String> keys = properties.stringPropertyNames();
        for (String key : keys) {
            Class<?> converterClazz;
            Class<?> clazz;
            String value = properties.getProperty(key);
            logger.trace((Object)("Mapping transformer class " + key + " to transformer converter class " + value));
            try {
                clazz = classLoader.loadClass(key);
            }
            catch (ClassNotFoundException cnfe) {
                logger.warn((Object)"Failed to load transformer class", (Throwable)cnfe);
                continue;
            }
            if (!Transformer.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("Transformer class " + clazz.getName() + " is not a subclass of " + Transformer.class.getName());
            }
            try {
                converterClazz = classLoader.loadClass(value);
            }
            catch (ClassNotFoundException cnfe) {
                logger.warn((Object)"Failed to load transformer converter class", (Throwable)cnfe);
                continue;
            }
            if (!TransformerConverter.class.isAssignableFrom(converterClazz)) {
                throw new IllegalArgumentException("Transformer converter class " + converterClazz.getName() + " is not a subclass of " + TransformerConverter.class.getName());
            }
            converters.put(clazz, converterClazz);
        }
    }

    private static int[] parseVersion(String string) {
        Pattern pattern = Pattern.compile("^(\\d+)\\.(\\d+)(\\..*)?$");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            return new int[]{-1, -1};
        }
        return new int[]{Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2))};
    }

    private static String formatVersion(int[] version) {
        return String.valueOf(version[0]) + "." + String.valueOf(version[1]);
    }

    static {
        ConverterFactory.init();
    }
}

