/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.feature;

import java.util.ArrayList;
import java.util.List;
import org.apache.spark.ml.feature.PCAModel;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.Matrix;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.OpType;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sparkml.FeatureConverter;
import org.jpmml.sparkml.MatrixUtil;
import org.jpmml.sparkml.SparkMLEncoder;

public class PCAModelConverter
extends FeatureConverter<PCAModel> {
    public PCAModelConverter(PCAModel transformer) {
        super(transformer);
    }

    @Override
    public List<Feature> encodeFeatures(SparkMLEncoder encoder) {
        PCAModel transformer = (PCAModel)this.getTransformer();
        DenseMatrix pc = transformer.pc();
        List<Feature> features = encoder.getFeatures(transformer.getInputCol());
        MatrixUtil.checkRows(features.size(), (Matrix)pc);
        ArrayList<Feature> result = new ArrayList<Feature>();
        int length = transformer.getK();
        for (int i = 0; i < length; ++i) {
            Apply apply = new Apply("sum");
            for (int j = 0; j < features.size(); ++j) {
                Feature feature = features.get(j);
                ContinuousFeature continuousFeature = feature.toContinuousFeature();
                FieldRef expression = continuousFeature.ref();
                Double coefficient = pc.apply(j, i);
                if (!ValueUtil.isOne((Number)coefficient)) {
                    expression = PMMLUtil.createApply((String)"*", (Expression[])new Expression[]{expression, PMMLUtil.createConstant((Number)coefficient)});
                }
                apply.addExpressions(new Expression[]{expression});
            }
            DerivedField derivedField = encoder.createDerivedField(PCAModelConverter.formatName(transformer, i, length), OpType.CONTINUOUS, DataType.DOUBLE, (Expression)apply);
            result.add((Feature)new ContinuousFeature((PMMLEncoder)encoder, (Field)derivedField));
        }
        return result;
    }
}

