/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.model;

import org.apache.spark.ml.classification.LinearSVCModel;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.regression.RegressionModel;
import org.jpmml.converter.AbstractTransformation;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.Transformation;
import org.jpmml.converter.mining.MiningModelUtil;
import org.jpmml.sparkml.ClassificationModelConverter;
import org.jpmml.sparkml.model.HasRegressionTableOptions;
import org.jpmml.sparkml.model.LinearModelUtil;

public class LinearSVCModelConverter
extends ClassificationModelConverter<LinearSVCModel>
implements HasRegressionTableOptions {
    public LinearSVCModelConverter(LinearSVCModel model) {
        super(model);
    }

    public MiningModel encodeModel(Schema schema) {
        final LinearSVCModel model = (LinearSVCModel)this.getTransformer();
        AbstractTransformation transformation = new AbstractTransformation(){

            public Expression createExpression(FieldRef fieldRef) {
                return PMMLUtil.createApply((String)"threshold", (Expression[])new Expression[0]).addExpressions(new Expression[]{fieldRef, PMMLUtil.createConstant((Number)model.getThreshold())});
            }
        };
        Schema segmentSchema = schema.toAnonymousRegressorSchema(DataType.DOUBLE);
        Model linearModel = LinearModelUtil.createRegression(this, model.coefficients(), model.intercept(), segmentSchema).setOutput(ModelUtil.createPredictedOutput((FieldName)FieldName.create((String)"margin"), (OpType)OpType.CONTINUOUS, (DataType)DataType.DOUBLE, (Transformation[])new Transformation[]{transformation}));
        return MiningModelUtil.createBinaryLogisticClassification((Model)linearModel, (double)1.0, (double)0.0, (RegressionModel.NormalizationMethod)RegressionModel.NormalizationMethod.NONE, (boolean)false, (Schema)schema);
    }
}

