/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Objects;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.OpType;
import org.dmg.pmml.ParameterField;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.sparkml.WeightedTermFeature;

public class TermFeature
extends Feature {
    private DefineFunction defineFunction = null;
    private Feature feature = null;
    private String value = null;

    public TermFeature(PMMLEncoder encoder, DefineFunction defineFunction, Feature feature, String value) {
        super(encoder, FieldName.create((String)(defineFunction.getName() + "(" + value + ")")), defineFunction.getDataType());
        this.setDefineFunction(defineFunction);
        this.setFeature(feature);
        this.setValue(value);
    }

    public ContinuousFeature toContinuousFeature() {
        PMMLEncoder encoder = this.ensureEncoder();
        DerivedField derivedField = encoder.getDerivedField(this.getName());
        if (derivedField == null) {
            Apply apply = this.createApply();
            derivedField = encoder.createDerivedField(this.getName(), OpType.CONTINUOUS, this.getDataType(), (Expression)apply);
        }
        return new ContinuousFeature(encoder, (Field)derivedField);
    }

    public WeightedTermFeature toWeightedTermFeature(double weight) {
        DefineFunction defineFunction;
        String name;
        PMMLEncoder encoder = this.ensureEncoder();
        DefineFunction weightedDefineFunction = encoder.getDefineFunction(name = (defineFunction = this.getDefineFunction()).getName().replace("tf@", "tf-idf@"));
        if (weightedDefineFunction == null) {
            ParameterField weightField = new ParameterField(FieldName.create((String)"weight"));
            ArrayList<ParameterField> parameterFields = new ArrayList<ParameterField>(defineFunction.getParameterFields());
            parameterFields.add(weightField);
            Apply apply = PMMLUtil.createApply((String)"*", (Expression[])new Expression[]{defineFunction.getExpression(), new FieldRef(weightField.getName())});
            weightedDefineFunction = new DefineFunction(name, OpType.CONTINUOUS, parameterFields).setDataType(DataType.DOUBLE).setExpression((Expression)apply);
            encoder.addDefineFunction(weightedDefineFunction);
        }
        return new WeightedTermFeature(encoder, weightedDefineFunction, this.getFeature(), this.getValue(), weight);
    }

    public Apply createApply() {
        DefineFunction defineFunction = this.getDefineFunction();
        Feature feature = this.getFeature();
        String value = this.getValue();
        Constant constant = PMMLUtil.createConstant((Object)value, (DataType)DataType.STRING);
        return PMMLUtil.createApply((String)defineFunction.getName(), (Expression[])new Expression[]{feature.ref(), constant});
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.getDefineFunction());
        result = 31 * result + Objects.hashCode(this.getFeature());
        result = 31 * result + Objects.hashCode(this.getValue());
        return result;
    }

    public boolean equals(Object object) {
        if (object instanceof TermFeature) {
            TermFeature that = (TermFeature)((Object)object);
            return super.equals(object) && Objects.equals(this.getDefineFunction(), that.getDefineFunction()) && Objects.equals(this.getFeature(), that.getFeature()) && Objects.equals(this.getValue(), that.getValue());
        }
        return false;
    }

    protected Objects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("defineFunction", (Object)this.getDefineFunction()).add("feature", (Object)this.getFeature()).add("value", (Object)this.getValue());
    }

    public DefineFunction getDefineFunction() {
        return this.defineFunction;
    }

    private void setDefineFunction(DefineFunction defineFunction) {
        if (defineFunction == null) {
            throw new IllegalArgumentException();
        }
        this.defineFunction = defineFunction;
    }

    public Feature getFeature() {
        return this.feature;
    }

    private void setFeature(Feature feature) {
        if (feature == null) {
            throw new IllegalArgumentException();
        }
        this.feature = feature;
    }

    public String getValue() {
        return this.value;
    }

    private void setValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.value = value;
    }
}

