/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml;

import java.util.List;
import org.apache.spark.ml.Transformer;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.shared.HasOutputCol;
import org.apache.spark.ml.param.shared.HasOutputCols;
import org.dmg.pmml.FieldName;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FieldNameUtil;
import org.jpmml.converter.SchemaUtil;
import org.jpmml.sparkml.BinarizedCategoricalFeature;
import org.jpmml.sparkml.SparkMLEncoder;
import org.jpmml.sparkml.TransformerConverter;

public abstract class FeatureConverter<T extends Transformer>
extends TransformerConverter<T> {
    public FeatureConverter(T transformer) {
        super(transformer);
    }

    public List<Feature> encodeFeatures(SparkMLEncoder encoder) {
        throw new UnsupportedOperationException();
    }

    public void registerFeatures(SparkMLEncoder encoder) {
        Object transformer = this.getTransformer();
        OutputMode outputMode = this.getOutputMode();
        if (OutputMode.SINGLE.equals((Object)outputMode)) {
            HasOutputCol hasOutputCol = (HasOutputCol)transformer;
            String outputCol = hasOutputCol.getOutputCol();
            List<Feature> features = this.encodeFeatures(encoder);
            encoder.putFeatures(outputCol, features);
        } else if (OutputMode.MULTIPLE.equals((Object)outputMode)) {
            HasOutputCols hasOutputCols = (HasOutputCols)transformer;
            String[] outputCols = hasOutputCols.getOutputCols();
            List<Feature> features = this.encodeFeatures(encoder);
            SchemaUtil.checkSize((int)outputCols.length, features);
            for (int i = 0; i < outputCols.length; ++i) {
                String outputCol = outputCols[i];
                Feature feature = features.get(i);
                if (feature instanceof BinarizedCategoricalFeature) {
                    BinarizedCategoricalFeature binarizedCategoricalFeature = (BinarizedCategoricalFeature)feature;
                    encoder.putFeatures(outputCol, binarizedCategoricalFeature.getBinaryFeatures());
                    continue;
                }
                encoder.putOnlyFeature(outputCol, feature);
            }
        }
    }

    protected OutputMode getOutputMode() {
        Object transformer = this.getTransformer();
        if (transformer instanceof HasOutputCol) {
            return OutputMode.SINGLE;
        }
        if (transformer instanceof HasOutputCols) {
            return OutputMode.MULTIPLE;
        }
        return null;
    }

    public static <T extends Transformer> FieldName formatName(T transformer) {
        return FieldName.create((String)((HasOutputCol)transformer).getOutputCol());
    }

    public static <T extends Transformer & HasOutputCols> FieldName formatName(T transformer, int index) {
        if (transformer.isSet((Param)((HasOutputCols)transformer).outputCols())) {
            return FieldName.create((String)((HasOutputCols)transformer).getOutputCols()[index]);
        }
        if (index != 0) {
            throw new IllegalArgumentException();
        }
        return FieldName.create((String)((HasOutputCol)transformer).getOutputCol());
    }

    public static <T extends Transformer> FieldName formatName(T transformer, int index, int length) {
        if (length > 1) {
            return FieldNameUtil.select((FieldName)FieldName.create((String)((HasOutputCol)transformer).getOutputCol()), (int)index);
        }
        return FieldName.create((String)((HasOutputCol)transformer).getOutputCol());
    }

    protected static enum OutputMode {
        SINGLE,
        MULTIPLE;

    }
}

