/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.model;

import org.apache.spark.ml.classification.NaiveBayesModel;
import org.apache.spark.ml.param.Param;
import org.dmg.pmml.Model;
import org.jpmml.converter.Schema;
import org.jpmml.sparkml.ClassificationModelConverter;
import org.jpmml.sparkml.model.HasRegressionTableOptions;
import org.jpmml.sparkml.model.LinearModelUtil;

public class NaiveBayesModelConverter
extends ClassificationModelConverter<NaiveBayesModel>
implements HasRegressionTableOptions {
    public NaiveBayesModelConverter(NaiveBayesModel model) {
        super(model);
    }

    @Override
    public Model encodeModel(Schema schema) {
        String modelType;
        NaiveBayesModel model = (NaiveBayesModel)this.getTransformer();
        switch (modelType = model.getModelType()) {
            case "multinomial": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Model type " + modelType + " is not supported");
            }
        }
        if (model.isSet((Param)model.thresholds())) {
            double[] thresholds = model.getThresholds();
            for (int i = 0; i < thresholds.length; ++i) {
                double threshold = thresholds[i];
                if (threshold == 0.0) continue;
                throw new IllegalArgumentException("Non-zero thresholds are not supported");
            }
        }
        Model linearModel = LinearModelUtil.createSoftmaxClassification(this, model.theta(), model.pi(), schema).setOutput(null);
        return linearModel;
    }
}

