/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.classification.DecisionTreeClassificationModel;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel;
import org.apache.spark.ml.tree.CategoricalSplit;
import org.apache.spark.ml.tree.ContinuousSplit;
import org.apache.spark.ml.tree.DecisionTreeModel;
import org.apache.spark.ml.tree.InternalNode;
import org.apache.spark.ml.tree.LeafNode;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.tree.Split;
import org.apache.spark.ml.tree.TreeEnsembleModel;
import org.apache.spark.mllib.tree.impurity.ImpurityCalculator;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.ScoreDistribution;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.True;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.BooleanFeature;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PredicateManager;
import org.jpmml.converter.Schema;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sparkml.TreeModelOptions;
import org.jpmml.sparkml.visitors.TreeModelCompactor;

public class TreeModelUtil {
    private static final double[] TRUE = new double[]{1.0};
    private static final double[] FALSE = new double[]{0.0};

    private TreeModelUtil() {
    }

    public static <M extends Model<M>, T extends Model<T>> List<TreeModel> encodeDecisionTreeEnsemble(M model, Schema schema) {
        PredicateManager predicateManager = new PredicateManager();
        return TreeModelUtil.encodeDecisionTreeEnsemble(model, predicateManager, schema);
    }

    public static <M extends Model<M>, T extends Model<T>> List<TreeModel> encodeDecisionTreeEnsemble(M model, PredicateManager predicateManager, Schema schema) {
        Model[] trees;
        Schema segmentSchema = schema.toAnonymousSchema();
        ArrayList<TreeModel> treeModels = new ArrayList<TreeModel>();
        for (Model tree : trees = (Model[])((TreeEnsembleModel)model).trees()) {
            TreeModel treeModel = TreeModelUtil.encodeDecisionTree(tree, predicateManager, segmentSchema);
            treeModels.add(treeModel);
        }
        return treeModels;
    }

    public static <M extends Model<M>> TreeModel encodeDecisionTree(M model, Schema schema) {
        PredicateManager predicateManager = new PredicateManager();
        return TreeModelUtil.encodeDecisionTree(model, predicateManager, schema);
    }

    public static <M extends Model<M>> TreeModel encodeDecisionTree(M model, PredicateManager predicateManager, final Schema schema) {
        if (model instanceof DecisionTreeRegressionModel) {
            ScoreEncoder scoreEncoder = new ScoreEncoder(){

                @Override
                public void encode(org.dmg.pmml.tree.Node node, LeafNode leafNode) {
                    String score = ValueUtil.formatValue((Number)leafNode.prediction());
                    node.setScore(score);
                }
            };
            return TreeModelUtil.encodeTreeModel(model, predicateManager, MiningFunction.REGRESSION, scoreEncoder, schema);
        }
        if (model instanceof DecisionTreeClassificationModel) {
            ScoreEncoder scoreEncoder = new ScoreEncoder(){
                private CategoricalLabel categoricalLabel;
                {
                    this.categoricalLabel = (CategoricalLabel)schema.getLabel();
                }

                @Override
                public void encode(org.dmg.pmml.tree.Node node, LeafNode leafNode) {
                    int index = ValueUtil.asInt((Number)leafNode.prediction());
                    node.setScore(this.categoricalLabel.getValue(index));
                    ImpurityCalculator impurityCalculator = leafNode.impurityStats();
                    node.setRecordCount(Double.valueOf(impurityCalculator.count()));
                    double[] stats = impurityCalculator.stats();
                    for (int i = 0; i < stats.length; ++i) {
                        ScoreDistribution scoreDistribution = new ScoreDistribution(this.categoricalLabel.getValue(i), stats[i]);
                        node.addScoreDistributions(new ScoreDistribution[]{scoreDistribution});
                    }
                }
            };
            return TreeModelUtil.encodeTreeModel(model, predicateManager, MiningFunction.CLASSIFICATION, scoreEncoder, schema);
        }
        throw new IllegalArgumentException();
    }

    private static <M extends Model<M>> TreeModel encodeTreeModel(M model, PredicateManager predicateManager, MiningFunction miningFunction, ScoreEncoder scoreEncoder, Schema schema) {
        org.dmg.pmml.tree.Node root = new org.dmg.pmml.tree.Node().setPredicate((Predicate)new True());
        TreeModelUtil.encodeNode(root, ((DecisionTreeModel)model).rootNode(), predicateManager, Collections.emptyMap(), scoreEncoder, schema);
        TreeModel treeModel = new TreeModel(miningFunction, ModelUtil.createMiningSchema((Label)schema.getLabel()), root).setSplitCharacteristic(TreeModel.SplitCharacteristic.BINARY_SPLIT);
        String compact = TreeModelOptions.COMPACT;
        if (compact != null && Boolean.parseBoolean(compact)) {
            TreeModelCompactor visitor = new TreeModelCompactor();
            visitor.applyTo((Visitable)treeModel);
        }
        return treeModel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void encodeNode(org.dmg.pmml.tree.Node node, Node sparkNode, PredicateManager predicateManager, Map<FieldName, Set<String>> parentFieldValues, ScoreEncoder scoreEncoder, Schema schema) {
        if (sparkNode instanceof LeafNode) {
            LeafNode leafNode = (LeafNode)sparkNode;
            scoreEncoder.encode(node, leafNode);
            return;
        } else {
            Predicate rightPredicate;
            Predicate leftPredicate;
            if (!(sparkNode instanceof InternalNode)) throw new IllegalArgumentException();
            InternalNode internalNode = (InternalNode)sparkNode;
            Map<FieldName, Set<String>> leftFieldValues = parentFieldValues;
            Map<FieldName, Set<String>> rightFieldValues = parentFieldValues;
            Split split = internalNode.split();
            Feature feature = schema.getFeature(split.featureIndex());
            if (split instanceof ContinuousSplit) {
                ContinuousSplit continuousSplit = (ContinuousSplit)split;
                double threshold = continuousSplit.threshold();
                if (feature instanceof BooleanFeature) {
                    BooleanFeature booleanFeature = (BooleanFeature)feature;
                    if (threshold != 0.5) {
                        throw new IllegalArgumentException();
                    }
                    leftPredicate = predicateManager.createSimplePredicate((Feature)booleanFeature, SimplePredicate.Operator.EQUAL, booleanFeature.getValue(0));
                    rightPredicate = predicateManager.createSimplePredicate((Feature)booleanFeature, SimplePredicate.Operator.EQUAL, booleanFeature.getValue(1));
                } else {
                    ContinuousFeature continuousFeature = feature.toContinuousFeature();
                    String value = ValueUtil.formatValue((Number)threshold);
                    leftPredicate = predicateManager.createSimplePredicate((Feature)continuousFeature, SimplePredicate.Operator.LESS_OR_EQUAL, value);
                    rightPredicate = predicateManager.createSimplePredicate((Feature)continuousFeature, SimplePredicate.Operator.GREATER_THAN, value);
                }
            } else {
                if (!(split instanceof CategoricalSplit)) throw new IllegalArgumentException();
                CategoricalSplit categoricalSplit = (CategoricalSplit)split;
                double[] leftCategories = categoricalSplit.leftCategories();
                double[] rightCategories = categoricalSplit.rightCategories();
                if (feature instanceof BinaryFeature) {
                    SimplePredicate.Operator rightOperator;
                    SimplePredicate.Operator leftOperator;
                    BinaryFeature binaryFeature = (BinaryFeature)feature;
                    if (Arrays.equals(TRUE, leftCategories) && Arrays.equals(FALSE, rightCategories)) {
                        leftOperator = SimplePredicate.Operator.EQUAL;
                        rightOperator = SimplePredicate.Operator.NOT_EQUAL;
                    } else {
                        if (!Arrays.equals(FALSE, leftCategories) || !Arrays.equals(TRUE, rightCategories)) throw new IllegalArgumentException();
                        leftOperator = SimplePredicate.Operator.NOT_EQUAL;
                        rightOperator = SimplePredicate.Operator.EQUAL;
                    }
                    String value = ValueUtil.formatValue((Object)binaryFeature.getValue());
                    leftPredicate = predicateManager.createSimplePredicate((Feature)binaryFeature, leftOperator, value);
                    rightPredicate = predicateManager.createSimplePredicate((Feature)binaryFeature, rightOperator, value);
                } else {
                    if (!(feature instanceof CategoricalFeature)) throw new IllegalArgumentException();
                    CategoricalFeature categoricalFeature = (CategoricalFeature)feature;
                    FieldName name = categoricalFeature.getName();
                    List values = categoricalFeature.getValues();
                    if (values.size() != leftCategories.length + rightCategories.length) {
                        throw new IllegalArgumentException();
                    }
                    final Set<String> parentValues = parentFieldValues.get(name);
                    java.util.function.Predicate<String> valueFilter = new java.util.function.Predicate<String>(){

                        @Override
                        public boolean test(String value) {
                            if (parentValues != null) {
                                return parentValues.contains(value);
                            }
                            return true;
                        }
                    };
                    List<String> leftValues = TreeModelUtil.selectValues(values, leftCategories, valueFilter);
                    List<String> rightValues = TreeModelUtil.selectValues(values, rightCategories, valueFilter);
                    leftFieldValues = new HashMap<FieldName, Set<String>>(parentFieldValues);
                    leftFieldValues.put(name, new HashSet<String>(leftValues));
                    rightFieldValues = new HashMap<FieldName, Set<String>>(parentFieldValues);
                    rightFieldValues.put(name, new HashSet<String>(rightValues));
                    leftPredicate = predicateManager.createSimpleSetPredicate((Feature)categoricalFeature, leftValues);
                    rightPredicate = predicateManager.createSimpleSetPredicate((Feature)categoricalFeature, rightValues);
                }
            }
            org.dmg.pmml.tree.Node leftChild = new org.dmg.pmml.tree.Node().setPredicate(leftPredicate);
            org.dmg.pmml.tree.Node rightChild = new org.dmg.pmml.tree.Node().setPredicate(rightPredicate);
            TreeModelUtil.encodeNode(leftChild, internalNode.leftChild(), predicateManager, leftFieldValues, scoreEncoder, schema);
            TreeModelUtil.encodeNode(rightChild, internalNode.rightChild(), predicateManager, rightFieldValues, scoreEncoder, schema);
            node.addNodes(new org.dmg.pmml.tree.Node[]{leftChild, rightChild});
        }
    }

    private static List<String> selectValues(List<String> values, double[] categories, java.util.function.Predicate<String> valueFilter) {
        if (categories.length == 1) {
            int index = ValueUtil.asInt((Number)categories[0]);
            String value = values.get(index);
            if (valueFilter.test(value)) {
                return Collections.singletonList(value);
            }
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(categories.length);
        for (int i = 0; i < categories.length; ++i) {
            int index = ValueUtil.asInt((Number)categories[i]);
            String value = values.get(index);
            if (!valueFilter.test(value)) continue;
            result.add(value);
        }
        return result;
    }

    static interface ScoreEncoder {
        public void encode(org.dmg.pmml.tree.Node var1, LeafNode var2);
    }
}

