/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.feature;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.spark.ml.feature.VectorIndexerModel;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.OpType;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sparkml.FeatureConverter;
import org.jpmml.sparkml.SparkMLEncoder;

public class VectorIndexerModelConverter
extends FeatureConverter<VectorIndexerModel> {
    private static final Comparator<Map.Entry<Double, Integer>> COMPARATOR = new Comparator<Map.Entry<Double, Integer>>(){

        @Override
        public int compare(Map.Entry<Double, Integer> left, Map.Entry<Double, Integer> right) {
            return left.getValue().compareTo(right.getValue());
        }
    };

    public VectorIndexerModelConverter(VectorIndexerModel transformer) {
        super(transformer);
    }

    @Override
    public List<Feature> encodeFeatures(SparkMLEncoder encoder) {
        VectorIndexerModel transformer = (VectorIndexerModel)this.getTransformer();
        List<Feature> features = encoder.getFeatures(transformer.getInputCol());
        int numFeatures = transformer.numFeatures();
        if (numFeatures != features.size()) {
            throw new IllegalArgumentException("Expected " + numFeatures + " features, got " + features.size() + " features");
        }
        Map categoryMaps = transformer.javaCategoryMaps();
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < numFeatures; ++i) {
            Feature feature = features.get(i);
            Map categoryMap = (Map)categoryMaps.get(i);
            if (categoryMap != null) {
                ArrayList<String> categories = new ArrayList<String>();
                ArrayList<String> values = new ArrayList<String>();
                ArrayList entries = new ArrayList(categoryMap.entrySet());
                Collections.sort(entries, COMPARATOR);
                for (Map.Entry entry : entries) {
                    String category = ValueUtil.formatValue((Number)((Number)entry.getKey()));
                    String value = ValueUtil.formatValue((Number)((Number)entry.getValue()));
                    categories.add(category);
                    values.add(value);
                }
                encoder.toCategorical(feature.getName(), categories);
                MapValues mapValues = PMMLUtil.createMapValues((FieldName)feature.getName(), categories, values);
                DerivedField derivedField = encoder.createDerivedField(VectorIndexerModelConverter.formatName(transformer, i), OpType.CATEGORICAL, DataType.INTEGER, (Expression)mapValues);
                result.add((Feature)new CategoricalFeature((PMMLEncoder)encoder, (Field)derivedField, values));
                continue;
            }
            result.add((Feature)((ContinuousFeature)feature));
        }
        return result;
    }
}

