/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.visitors;

import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.dmg.pmml.True;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.tree.Node;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.model.visitors.AbstractVisitor;

public class TreeModelCompactor
extends AbstractVisitor {
    private MiningFunction miningFunction = null;
    private Map<True, FieldName> categoricalFields = new IdentityHashMap<True, FieldName>();

    public void pushParent(PMMLObject object) {
        super.pushParent(object);
        if (object instanceof Node) {
            this.handleNodePush((Node)object);
        } else if (object instanceof TreeModel) {
            this.handleTreeModelPush((TreeModel)object);
        }
    }

    public PMMLObject popParent() {
        PMMLObject object = super.popParent();
        if (object instanceof Node) {
            this.handleNodePop((Node)object);
        } else if (object instanceof TreeModel) {
            this.handleTreeModelPop((TreeModel)object);
        }
        return object;
    }

    public VisitorAction visit(TreeModel treeModel) {
        TreeModel.MissingValueStrategy missingValueStrategy = treeModel.getMissingValueStrategy();
        TreeModel.NoTrueChildStrategy noTrueChildStrategy = treeModel.getNoTrueChildStrategy();
        TreeModel.SplitCharacteristic splitCharacteristic = treeModel.getSplitCharacteristic();
        if (!(TreeModel.MissingValueStrategy.NONE.equals((Object)missingValueStrategy) && TreeModel.NoTrueChildStrategy.RETURN_NULL_PREDICTION.equals((Object)noTrueChildStrategy) && TreeModel.SplitCharacteristic.BINARY_SPLIT.equals((Object)splitCharacteristic))) {
            throw new IllegalArgumentException();
        }
        treeModel.setMissingValueStrategy(TreeModel.MissingValueStrategy.NULL_PREDICTION).setSplitCharacteristic(TreeModel.SplitCharacteristic.MULTI_SPLIT);
        MiningFunction miningFunction = treeModel.getMiningFunction();
        switch (miningFunction) {
            case REGRESSION: {
                treeModel.setNoTrueChildStrategy(TreeModel.NoTrueChildStrategy.RETURN_LAST_PREDICTION);
                break;
            }
            case CLASSIFICATION: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return super.visit(treeModel);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleNodePush(Node node) {
        String id = node.getId();
        String score = node.getScore();
        if (id != null) {
            throw new IllegalArgumentException();
        }
        if (node.hasNodes()) {
            List children = node.getNodes();
            if (children.size() != 2 || score != null) {
                throw new IllegalArgumentException();
            }
            Node firstChild = (Node)children.get(0);
            Node secondChild = (Node)children.get(1);
            Predicate firstPredicate = firstChild.getPredicate();
            Predicate secondPredicate = secondChild.getPredicate();
            if (firstPredicate instanceof SimplePredicate && secondPredicate instanceof SimplePredicate) {
                SimplePredicate firstSimplePredicate = (SimplePredicate)firstPredicate;
                SimplePredicate secondSimplePredicate = (SimplePredicate)secondPredicate;
                SimplePredicate.Operator firstOperator = firstSimplePredicate.getOperator();
                SimplePredicate.Operator secondOperator = secondSimplePredicate.getOperator();
                if (!firstSimplePredicate.getField().equals((Object)secondSimplePredicate.getField())) {
                    throw new IllegalArgumentException();
                }
                if (SimplePredicate.Operator.EQUAL.equals((Object)firstOperator) && SimplePredicate.Operator.EQUAL.equals((Object)secondOperator)) {
                    if (!this.isCategoricalField(firstSimplePredicate.getField())) return;
                    secondChild.setPredicate((Predicate)new True());
                    return;
                } else {
                    if (!firstSimplePredicate.getValue().equals(secondSimplePredicate.getValue())) {
                        throw new IllegalArgumentException();
                    }
                    if (SimplePredicate.Operator.NOT_EQUAL.equals((Object)firstOperator) && SimplePredicate.Operator.EQUAL.equals((Object)secondOperator)) {
                        TreeModelCompactor.swapChildren(children);
                        firstChild = (Node)children.get(0);
                        secondChild = (Node)children.get(1);
                    } else if (!(SimplePredicate.Operator.EQUAL.equals((Object)firstOperator) && SimplePredicate.Operator.NOT_EQUAL.equals((Object)secondOperator) || SimplePredicate.Operator.LESS_OR_EQUAL.equals((Object)firstOperator) && SimplePredicate.Operator.GREATER_THAN.equals((Object)secondOperator))) {
                        throw new IllegalArgumentException();
                    }
                    secondChild.setPredicate((Predicate)new True());
                }
                return;
            } else if (firstPredicate instanceof SimplePredicate && secondPredicate instanceof SimpleSetPredicate) {
                SimplePredicate simplePredicate = (SimplePredicate)firstPredicate;
                SimpleSetPredicate simpleSetPredicate = (SimpleSetPredicate)secondPredicate;
                if (!(simplePredicate.getField().equals((Object)simpleSetPredicate.getField()) && SimplePredicate.Operator.EQUAL.equals((Object)simplePredicate.getOperator()) && SimpleSetPredicate.BooleanOperator.IS_IN.equals((Object)simpleSetPredicate.getBooleanOperator()))) {
                    throw new IllegalArgumentException();
                }
                secondChild.setPredicate((Predicate)this.addCategoricalField(simpleSetPredicate));
                return;
            } else if (firstPredicate instanceof SimpleSetPredicate && secondPredicate instanceof SimplePredicate) {
                SimpleSetPredicate simpleSetPredicate = (SimpleSetPredicate)firstPredicate;
                SimplePredicate simplePredicate = (SimplePredicate)secondPredicate;
                if (!(simpleSetPredicate.getField().equals((Object)simplePredicate.getField()) && SimpleSetPredicate.BooleanOperator.IS_IN.equals((Object)simpleSetPredicate.getBooleanOperator()) && SimplePredicate.Operator.EQUAL.equals((Object)simplePredicate.getOperator()))) {
                    throw new IllegalArgumentException();
                }
                TreeModelCompactor.swapChildren(children);
                firstChild = (Node)children.get(0);
                secondChild = (Node)children.get(1);
                secondChild.setPredicate((Predicate)this.addCategoricalField(simpleSetPredicate));
                return;
            } else {
                if (!(firstPredicate instanceof SimpleSetPredicate) || !(secondPredicate instanceof SimpleSetPredicate)) throw new IllegalArgumentException();
                SimpleSetPredicate firstSimpleSetPredicate = (SimpleSetPredicate)firstPredicate;
                SimpleSetPredicate secondSimpleSetPredicate = (SimpleSetPredicate)secondPredicate;
                if (!(firstSimpleSetPredicate.getField().equals((Object)secondSimpleSetPredicate.getField()) && SimpleSetPredicate.BooleanOperator.IS_IN.equals((Object)firstSimpleSetPredicate.getBooleanOperator()) && SimpleSetPredicate.BooleanOperator.IS_IN.equals((Object)secondSimpleSetPredicate.getBooleanOperator()))) {
                    throw new IllegalArgumentException();
                }
                secondChild.setPredicate((Predicate)this.addCategoricalField(secondSimpleSetPredicate));
            }
            return;
        } else {
            if (score != null) return;
            throw new IllegalArgumentException();
        }
    }

    private void handleNodePop(Node node) {
        String score = node.getScore();
        Predicate predicate = node.getPredicate();
        if (predicate instanceof True) {
            Node parentNode = this.getParentNode();
            if (parentNode == null) {
                return;
            }
            String parentScore = parentNode.getScore();
            if (parentScore != null) {
                throw new IllegalArgumentException();
            }
            if (MiningFunction.REGRESSION.equals((Object)this.miningFunction)) {
                parentNode.setScore(score);
                List parentChildren = parentNode.getNodes();
                boolean success = parentChildren.remove(node);
                if (!success) {
                    throw new IllegalArgumentException();
                }
                if (node.hasNodes()) {
                    List children = node.getNodes();
                    parentChildren.addAll(children);
                }
            } else if (MiningFunction.CLASSIFICATION.equals((Object)this.miningFunction)) {
                if (node.hasNodes()) {
                    List parentChildren = parentNode.getNodes();
                    boolean success = parentChildren.remove(node);
                    if (!success) {
                        throw new IllegalArgumentException();
                    }
                    List children = node.getNodes();
                    parentChildren.addAll(children);
                }
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    private void handleTreeModelPush(TreeModel treeModel) {
        this.miningFunction = treeModel.getMiningFunction();
        this.categoricalFields.clear();
    }

    private void handleTreeModelPop(TreeModel treeModel) {
        this.miningFunction = null;
    }

    private boolean isCategoricalField(FieldName name) {
        Deque parents = this.getParents();
        for (PMMLObject parent : parents) {
            if (parent instanceof Node) {
                True truePredicate;
                SimpleSetPredicate simpleSetPredicate;
                FieldName categoricalField;
                Node node = (Node)parent;
                Predicate predicate = node.getPredicate();
                if (!(predicate instanceof SimpleSetPredicate ? name.equals((Object)(categoricalField = (simpleSetPredicate = (SimpleSetPredicate)predicate).getField())) : predicate instanceof True && name.equals((Object)(categoricalField = this.categoricalFields.get(truePredicate = (True)predicate))))) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private True addCategoricalField(SimpleSetPredicate simpleSetPredicate) {
        True truePredicate = new True();
        this.categoricalFields.put(truePredicate, simpleSetPredicate.getField());
        return truePredicate;
    }

    private Node getParentNode() {
        Deque parents = this.getParents();
        PMMLObject parent = (PMMLObject)parents.peekFirst();
        if (parent instanceof Node) {
            return (Node)parent;
        }
        return null;
    }

    private static void swapChildren(List<Node> children) {
        Node firstChild = children.remove(0);
        children.add(1, firstChild);
    }
}

