/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml;

import java.util.List;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAlias;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.analysis.UnresolvedFunction;
import org.apache.spark.sql.catalyst.expressions.Add;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.BinaryArithmetic;
import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.BinaryOperator;
import org.apache.spark.sql.catalyst.expressions.Divide;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.GreaterThan;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.IsNotNull;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.LessThan;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Multiply;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.catalyst.expressions.Subtract;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.StringType;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.sparkml.ExpressionMapping;
import scala.collection.JavaConversions;
import scala.collection.Seq;

public class ExpressionTranslator {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExpressionMapping translate(org.apache.spark.sql.catalyst.expressions.Expression expression, DataTypeResolver dataTypeResolver) {
        if (expression instanceof UnresolvedAlias) {
            UnresolvedAlias unresolvedAlias = (UnresolvedAlias)expression;
            org.apache.spark.sql.catalyst.expressions.Expression child = unresolvedAlias.child();
            return ExpressionTranslator.translate(child, dataTypeResolver);
        }
        if (expression instanceof UnresolvedAttribute) {
            UnresolvedAttribute unresolvedAttribute = (UnresolvedAttribute)expression;
            String name = unresolvedAttribute.name();
            return new ExpressionMapping((org.apache.spark.sql.catalyst.expressions.Expression)unresolvedAttribute, (Expression)new FieldRef(FieldName.create((String)name)), dataTypeResolver.getDataType(name));
        }
        if (expression instanceof UnresolvedFunction) {
            UnresolvedFunction unresolvedFunction = (UnresolvedFunction)expression;
            FunctionIdentifier name = unresolvedFunction.name();
            List children = JavaConversions.seqAsJavaList((Seq)unresolvedFunction.children());
            String identifier = name.identifier();
            if ("IF".equalsIgnoreCase(identifier) && children.size() == 3) {
                return ExpressionTranslator.translate((org.apache.spark.sql.catalyst.expressions.Expression)new If((org.apache.spark.sql.catalyst.expressions.Expression)children.get(0), (org.apache.spark.sql.catalyst.expressions.Expression)children.get(1), (org.apache.spark.sql.catalyst.expressions.Expression)children.get(2)), dataTypeResolver);
            }
            if ("ISNOTNULL".equalsIgnoreCase(identifier) && children.size() == 1) {
                return ExpressionTranslator.translate((org.apache.spark.sql.catalyst.expressions.Expression)new IsNotNull((org.apache.spark.sql.catalyst.expressions.Expression)children.get(0)), dataTypeResolver);
            }
            if (!"ISNULL".equalsIgnoreCase(identifier) || children.size() != 1) throw new IllegalArgumentException(String.valueOf(unresolvedFunction));
            return ExpressionTranslator.translate((org.apache.spark.sql.catalyst.expressions.Expression)new IsNull((org.apache.spark.sql.catalyst.expressions.Expression)children.get(0)), dataTypeResolver);
        }
        if (expression instanceof BinaryOperator) {
            DataType dataType;
            BinaryOperator binaryOperator = (BinaryOperator)expression;
            String symbol = binaryOperator.symbol();
            org.apache.spark.sql.catalyst.expressions.Expression left = binaryOperator.left();
            org.apache.spark.sql.catalyst.expressions.Expression right = binaryOperator.right();
            if (expression instanceof And || expression instanceof Or) {
                symbol = symbol.toLowerCase();
                dataType = DataType.BOOLEAN;
                return new ExpressionMapping((org.apache.spark.sql.catalyst.expressions.Expression)binaryOperator, (Expression)PMMLUtil.createApply((String)symbol, (Expression[])new Expression[]{ExpressionTranslator.translateChild(left, dataTypeResolver), ExpressionTranslator.translateChild(right, dataTypeResolver)}), dataType);
            } else if (expression instanceof Add || expression instanceof Divide || expression instanceof Multiply || expression instanceof Subtract) {
                BinaryArithmetic binaryArithmetic = (BinaryArithmetic)binaryOperator;
                if (left.dataType().acceptsType(right.dataType())) {
                    dataType = ExpressionTranslator.translateDataType(left.dataType());
                    return new ExpressionMapping((org.apache.spark.sql.catalyst.expressions.Expression)binaryOperator, (Expression)PMMLUtil.createApply((String)symbol, (Expression[])new Expression[]{ExpressionTranslator.translateChild(left, dataTypeResolver), ExpressionTranslator.translateChild(right, dataTypeResolver)}), dataType);
                } else {
                    if (!right.dataType().acceptsType(left.dataType())) throw new IllegalArgumentException(String.valueOf(binaryArithmetic));
                    dataType = ExpressionTranslator.translateDataType(right.dataType());
                }
                return new ExpressionMapping((org.apache.spark.sql.catalyst.expressions.Expression)binaryOperator, (Expression)PMMLUtil.createApply((String)symbol, (Expression[])new Expression[]{ExpressionTranslator.translateChild(left, dataTypeResolver), ExpressionTranslator.translateChild(right, dataTypeResolver)}), dataType);
            } else {
                if (!(expression instanceof EqualTo) && !(expression instanceof GreaterThan) && !(expression instanceof GreaterThanOrEqual) && !(expression instanceof LessThan) && !(expression instanceof LessThanOrEqual)) throw new IllegalArgumentException(String.valueOf(binaryOperator));
                BinaryComparison binaryComparison = (BinaryComparison)binaryOperator;
                switch (symbol) {
                    case "=": {
                        symbol = "equal";
                        break;
                    }
                    case ">": {
                        symbol = "greaterThan";
                        break;
                    }
                    case ">=": {
                        symbol = "greaterOrEqual";
                        break;
                    }
                    case "<": {
                        symbol = "lessThan";
                        break;
                    }
                    case "<=": {
                        symbol = "lessOrEqual";
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(String.valueOf(binaryComparison));
                    }
                }
                dataType = DataType.BOOLEAN;
            }
            return new ExpressionMapping((org.apache.spark.sql.catalyst.expressions.Expression)binaryOperator, (Expression)PMMLUtil.createApply((String)symbol, (Expression[])new Expression[]{ExpressionTranslator.translateChild(left, dataTypeResolver), ExpressionTranslator.translateChild(right, dataTypeResolver)}), dataType);
        }
        if (expression instanceof If) {
            If _if = (If)expression;
            org.apache.spark.sql.catalyst.expressions.Expression predicate = _if.predicate();
            org.apache.spark.sql.catalyst.expressions.Expression trueValue = _if.trueValue();
            org.apache.spark.sql.catalyst.expressions.Expression falseValue = _if.falseValue();
            if (!trueValue.dataType().sameType(falseValue.dataType())) {
                throw new IllegalArgumentException(String.valueOf(_if));
            }
            DataType dataType = ExpressionTranslator.translateDataType(trueValue.dataType());
            Apply apply = PMMLUtil.createApply((String)"if", (Expression[])new Expression[]{ExpressionTranslator.translateChild(predicate, dataTypeResolver)}).addExpressions(new Expression[]{ExpressionTranslator.translateChild(trueValue, dataTypeResolver), ExpressionTranslator.translateChild(falseValue, dataTypeResolver)});
            return new ExpressionMapping((org.apache.spark.sql.catalyst.expressions.Expression)_if, (Expression)apply, dataType);
        }
        if (expression instanceof In) {
            In in = (In)expression;
            org.apache.spark.sql.catalyst.expressions.Expression value = in.value();
            List elements = JavaConversions.seqAsJavaList((Seq)in.list());
            Apply apply = PMMLUtil.createApply((String)"isIn", (Expression[])new Expression[]{ExpressionTranslator.translateChild(value, dataTypeResolver)});
            for (org.apache.spark.sql.catalyst.expressions.Expression element : elements) {
                apply.addExpressions(new Expression[]{ExpressionTranslator.translateChild(element, dataTypeResolver)});
            }
            return new ExpressionMapping((org.apache.spark.sql.catalyst.expressions.Expression)in, (Expression)apply, DataType.BOOLEAN);
        }
        if (expression instanceof Literal) {
            Literal literal = (Literal)expression;
            Object value = literal.value();
            DataType dataType = ExpressionTranslator.translateDataType(literal.dataType());
            return new ExpressionMapping((org.apache.spark.sql.catalyst.expressions.Expression)literal, (Expression)PMMLUtil.createConstant((Object)value, (DataType)dataType), dataType);
        }
        if (expression instanceof Not) {
            Not not = (Not)expression;
            org.apache.spark.sql.catalyst.expressions.Expression child = not.child();
            return new ExpressionMapping((org.apache.spark.sql.catalyst.expressions.Expression)not, (Expression)PMMLUtil.createApply((String)"not", (Expression[])new Expression[]{ExpressionTranslator.translateChild(child, dataTypeResolver)}), DataType.BOOLEAN);
        }
        if (!(expression instanceof UnaryExpression)) throw new IllegalArgumentException(String.valueOf(expression));
        UnaryExpression unaryExpression = (UnaryExpression)expression;
        org.apache.spark.sql.catalyst.expressions.Expression child = unaryExpression.child();
        if (expression instanceof IsNotNull) {
            return new ExpressionMapping((org.apache.spark.sql.catalyst.expressions.Expression)unaryExpression, (Expression)PMMLUtil.createApply((String)"isNotMissing", (Expression[])new Expression[]{ExpressionTranslator.translateChild(child, dataTypeResolver)}), DataType.BOOLEAN);
        }
        if (!(expression instanceof IsNull)) throw new IllegalArgumentException(String.valueOf(unaryExpression));
        return new ExpressionMapping((org.apache.spark.sql.catalyst.expressions.Expression)unaryExpression, (Expression)PMMLUtil.createApply((String)"isMissing", (Expression[])new Expression[]{ExpressionTranslator.translateChild(child, dataTypeResolver)}), DataType.BOOLEAN);
    }

    private static Expression translateChild(org.apache.spark.sql.catalyst.expressions.Expression expression, DataTypeResolver dataTypeResolver) {
        ExpressionMapping expressionMapping = ExpressionTranslator.translate(expression, dataTypeResolver);
        return expressionMapping.getTo();
    }

    private static DataType translateDataType(org.apache.spark.sql.types.DataType sparkDataType) {
        if (sparkDataType instanceof StringType) {
            return DataType.STRING;
        }
        if (sparkDataType instanceof IntegralType) {
            return DataType.INTEGER;
        }
        if (sparkDataType instanceof DoubleType) {
            return DataType.DOUBLE;
        }
        if (sparkDataType instanceof BooleanType) {
            return DataType.BOOLEAN;
        }
        throw new IllegalArgumentException("Expected string, integral, double or boolean type, got " + sparkDataType.typeName() + " type");
    }

    public static interface DataTypeResolver {
        public DataType getDataType(String var1);
    }
}

