/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.model;

import java.util.ArrayList;
import org.apache.spark.ml.classification.LinearSVCModel;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.regression.RegressionModel;
import org.jpmml.converter.AbstractTransformation;
import org.jpmml.converter.Feature;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.Transformation;
import org.jpmml.converter.mining.MiningModelUtil;
import org.jpmml.converter.regression.RegressionModelUtil;
import org.jpmml.sparkml.ClassificationModelConverter;
import org.jpmml.sparkml.VectorUtil;
import org.jpmml.sparkml.model.HasRegressionOptions;
import org.jpmml.sparkml.model.RegressionTableUtil;

public class LinearSVCModelConverter
extends ClassificationModelConverter<LinearSVCModel>
implements HasRegressionOptions {
    public LinearSVCModelConverter(LinearSVCModel model) {
        super(model);
    }

    public MiningModel encodeModel(Schema schema) {
        LinearSVCModel model = (LinearSVCModel)this.getTransformer();
        final double threshold = model.getThreshold();
        ArrayList<Feature> features = new ArrayList<Feature>(schema.getFeatures());
        ArrayList<Double> coefficients = new ArrayList<Double>(VectorUtil.toList(model.coefficients()));
        RegressionTableUtil.simplify(this, null, features, coefficients);
        AbstractTransformation transformation = new AbstractTransformation(){

            public Expression createExpression(FieldRef fieldRef) {
                return PMMLUtil.createApply((String)"if", (Expression[])new Expression[]{PMMLUtil.createApply((String)"greaterThan", (Expression[])new Expression[]{fieldRef, PMMLUtil.createConstant((Number)threshold)}), PMMLUtil.createConstant((Number)1), PMMLUtil.createConstant((Number)0)});
            }
        };
        Schema segmentSchema = schema.toAnonymousRegressorSchema(DataType.DOUBLE).toEmptySchema();
        RegressionModel regressionModel = RegressionModelUtil.createRegression(features, coefficients, (Double)model.intercept(), (RegressionModel.NormalizationMethod)RegressionModel.NormalizationMethod.NONE, (Schema)segmentSchema).setOutput(ModelUtil.createPredictedOutput((FieldName)FieldName.create((String)"margin"), (OpType)OpType.CONTINUOUS, (DataType)DataType.DOUBLE, (Transformation[])new Transformation[]{transformation}));
        return MiningModelUtil.createBinaryLogisticClassification((Model)regressionModel, (double)1.0, (double)0.0, (RegressionModel.NormalizationMethod)RegressionModel.NormalizationMethod.NONE, (boolean)false, (Schema)schema);
    }
}

