/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml;

import java.util.Collections;
import java.util.List;
import org.apache.spark.ml.PredictionModel;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.shared.HasFeaturesCol;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.OpType;
import org.dmg.pmml.OutputField;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.sparkml.ModelConverter;
import org.jpmml.sparkml.SparkMLEncoder;

public abstract class RegressionModelConverter<T extends PredictionModel<Vector, T> & HasFeaturesCol>
extends ModelConverter<T> {
    public RegressionModelConverter(T model) {
        super(model);
    }

    @Override
    public MiningFunction getMiningFunction() {
        return MiningFunction.REGRESSION;
    }

    @Override
    public List<OutputField> registerOutputFields(Label label, SparkMLEncoder encoder) {
        PredictionModel model = (PredictionModel)this.getTransformer();
        String predictionCol = model.getPredictionCol();
        OutputField predictedField = ModelUtil.createPredictedField((FieldName)FieldName.create((String)predictionCol), (DataType)label.getDataType(), (OpType)OpType.CONTINUOUS);
        encoder.putOnlyFeature(predictionCol, (Feature)new ContinuousFeature((PMMLEncoder)encoder, (Field)predictedField));
        return Collections.singletonList(predictedField);
    }
}

