/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.model;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.OpType;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sparkml.ModelConverter;
import org.jpmml.sparkml.SchemaUtil;

public class RegressionTableUtil {
    private RegressionTableUtil() {
    }

    public static <C extends ModelConverter<?>> void simplify(C converter, String identifier, List<Feature> features, List<Double> coefficients) {
        SchemaUtil.checkSize(coefficients.size(), features);
        Integer lookupThreshold = (Integer)converter.getOption("lookup_threshold", null);
        if (lookupThreshold == null) {
            return;
        }
        Map<FieldName, Long> countMap = features.stream().filter(feature -> feature instanceof BinaryFeature).collect(Collectors.groupingBy(feature -> ((BinaryFeature)feature).getName(), Collectors.counting()));
        Set<Map.Entry<FieldName, Long>> entries = countMap.entrySet();
        for (Map.Entry entry : entries) {
            if ((Long)entry.getValue() < (long)lookupThreshold.intValue()) continue;
            RegressionTableUtil.createMapValues((FieldName)entry.getKey(), identifier, features, coefficients);
        }
    }

    private static MapValues createMapValues(FieldName name, String identifier, List<Feature> features, List<Double> coefficients) {
        ListIterator<Feature> featureIt = features.listIterator();
        ListIterator<Double> coefficientIt = coefficients.listIterator();
        PMMLEncoder encoder = null;
        ArrayList<String> inputValues = new ArrayList<String>();
        ArrayList<String> outputValues = new ArrayList<String>();
        while (featureIt.hasNext()) {
            BinaryFeature binaryFeature;
            Feature feature = featureIt.next();
            Double coefficient = coefficientIt.next();
            if (!(feature instanceof BinaryFeature) || !name.equals((Object)(binaryFeature = (BinaryFeature)feature).getName())) continue;
            featureIt.remove();
            coefficientIt.remove();
            if (encoder == null) {
                encoder = binaryFeature.getEncoder();
            }
            inputValues.add(binaryFeature.getValue());
            outputValues.add(ValueUtil.formatValue((Number)coefficient));
        }
        MapValues mapValues = PMMLUtil.createMapValues((FieldName)name, inputValues, outputValues).setDefaultValue(ValueUtil.formatValue((Number)0.0));
        DerivedField derivedField = encoder.createDerivedField(FieldName.create((String)("lookup(" + name.getValue() + (identifier != null ? ", " + identifier : "") + ")")), OpType.CONTINUOUS, DataType.DOUBLE, (Expression)mapValues);
        featureIt.add((Feature)new ContinuousFeature(encoder, (Field)derivedField));
        coefficientIt.add(1.0);
        return mapValues;
    }
}

