/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.feature;

import java.util.ArrayList;
import java.util.List;
import org.apache.spark.ml.feature.OneHotEncoder;
import org.apache.spark.ml.param.Param;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.sparkml.FeatureConverter;
import org.jpmml.sparkml.SparkMLEncoder;
import scala.Option;

public class OneHotEncoderConverter
extends FeatureConverter<OneHotEncoder> {
    public OneHotEncoderConverter(OneHotEncoder transformer) {
        super(transformer);
    }

    @Override
    public List<Feature> encodeFeatures(SparkMLEncoder encoder) {
        OneHotEncoder transformer = (OneHotEncoder)this.getTransformer();
        CategoricalFeature categoricalFeature = (CategoricalFeature)encoder.getOnlyFeature(transformer.getInputCol());
        List values = categoricalFeature.getValues();
        boolean dropLast = true;
        Option dropLastOption = transformer.get((Param)transformer.dropLast());
        if (dropLastOption.isDefined()) {
            dropLast = (Boolean)dropLastOption.get();
        }
        return OneHotEncoderConverter.encodeFeature((PMMLEncoder)encoder, (Feature)categoricalFeature, values, dropLast);
    }

    public static List<Feature> encodeFeature(PMMLEncoder encoder, Feature feature, List<?> values, boolean dropLast) {
        ArrayList<Feature> result = new ArrayList<Feature>();
        if (dropLast) {
            values = values.subList(0, values.size() - 1);
        }
        for (Object value : values) {
            result.add((Feature)new BinaryFeature(encoder, feature, value));
        }
        return result;
    }
}

