/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.feature;

import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.spark.ml.feature.StopWordsRemover;
import org.jpmml.converter.Feature;
import org.jpmml.sparkml.DocumentFeature;
import org.jpmml.sparkml.FeatureConverter;
import org.jpmml.sparkml.SparkMLEncoder;
import org.jpmml.sparkml.TermUtil;

public class StopWordsRemoverConverter
extends FeatureConverter<StopWordsRemover> {
    public StopWordsRemoverConverter(StopWordsRemover transformer) {
        super(transformer);
    }

    @Override
    public List<Feature> encodeFeatures(SparkMLEncoder encoder) {
        String[] stopWords;
        StopWordsRemover transformer = (StopWordsRemover)this.getTransformer();
        DocumentFeature documentFeature = (DocumentFeature)encoder.getOnlyFeature(transformer.getInputCol());
        Pattern pattern = Pattern.compile(documentFeature.getWordSeparatorRE());
        DocumentFeature.StopWordSet stopWordSet = new DocumentFeature.StopWordSet(transformer.getCaseSensitive());
        for (String stopWord : stopWords = transformer.getStopWords()) {
            String[] stopTokens = pattern.split(stopWord);
            if (stopTokens.length > 1) continue;
            if (TermUtil.hasPunctuation(stopWord)) {
                throw new IllegalArgumentException("Punctuated stop words (" + stopWord + ") are not supported");
            }
            stopWordSet.add(stopWord);
        }
        documentFeature.addStopWordSet(stopWordSet);
        return Collections.singletonList(documentFeature);
    }
}

