/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.visitors;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.HasFieldReference;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.dmg.pmml.True;
import org.dmg.pmml.tree.Node;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.converter.visitors.AbstractTreeModelTransformer;

public class TreeModelCompactor
extends AbstractTreeModelTransformer {
    private MiningFunction miningFunction = null;
    private Map<Node, SimpleSetPredicate> replacedPredicates = new IdentityHashMap<Node, SimpleSetPredicate>();

    public void enterNode(Node node) {
        Object id = node.getId();
        Object score = node.getScore();
        if (id != null) {
            throw new IllegalArgumentException();
        }
        if (node.hasNodes()) {
            List children = node.getNodes();
            if (children.size() != 2 || score != null) {
                throw new IllegalArgumentException();
            }
            Node firstChild = (Node)children.get(0);
            Node secondChild = (Node)children.get(1);
            Predicate firstPredicate = firstChild.getPredicate();
            Predicate secondPredicate = secondChild.getPredicate();
            TreeModelCompactor.checkFieldReference((Predicate)firstPredicate, (Predicate)secondPredicate);
            boolean update = true;
            if (TreeModelCompactor.hasOperator((Predicate)firstPredicate, (SimplePredicate.Operator)SimplePredicate.Operator.EQUAL) && TreeModelCompactor.hasOperator((Predicate)secondPredicate, (SimplePredicate.Operator)SimplePredicate.Operator.EQUAL)) {
                update = this.isCategoricalField((HasFieldReference<?>)((SimplePredicate)firstPredicate));
            } else if (TreeModelCompactor.hasOperator((Predicate)firstPredicate, (SimplePredicate.Operator)SimplePredicate.Operator.NOT_EQUAL) && TreeModelCompactor.hasOperator((Predicate)secondPredicate, (SimplePredicate.Operator)SimplePredicate.Operator.EQUAL)) {
                children = TreeModelCompactor.swapChildren((Node)node);
                firstChild = (Node)children.get(0);
                secondChild = (Node)children.get(1);
            } else if (!(TreeModelCompactor.hasOperator((Predicate)firstPredicate, (SimplePredicate.Operator)SimplePredicate.Operator.EQUAL) && TreeModelCompactor.hasOperator((Predicate)secondPredicate, (SimplePredicate.Operator)SimplePredicate.Operator.NOT_EQUAL) || TreeModelCompactor.hasOperator((Predicate)firstPredicate, (SimplePredicate.Operator)SimplePredicate.Operator.LESS_OR_EQUAL) && TreeModelCompactor.hasOperator((Predicate)secondPredicate, (SimplePredicate.Operator)SimplePredicate.Operator.GREATER_THAN))) {
                if (TreeModelCompactor.hasOperator((Predicate)firstPredicate, (SimplePredicate.Operator)SimplePredicate.Operator.EQUAL) && TreeModelCompactor.hasBooleanOperator((Predicate)secondPredicate, (SimpleSetPredicate.BooleanOperator)SimpleSetPredicate.BooleanOperator.IS_IN)) {
                    this.addCategoricalField(secondChild);
                } else if (TreeModelCompactor.hasBooleanOperator((Predicate)firstPredicate, (SimpleSetPredicate.BooleanOperator)SimpleSetPredicate.BooleanOperator.IS_IN) && TreeModelCompactor.hasOperator((Predicate)secondPredicate, (SimplePredicate.Operator)SimplePredicate.Operator.EQUAL)) {
                    children = TreeModelCompactor.swapChildren((Node)node);
                    firstChild = (Node)children.get(0);
                    secondChild = (Node)children.get(1);
                    this.addCategoricalField(secondChild);
                } else if (TreeModelCompactor.hasBooleanOperator((Predicate)firstPredicate, (SimpleSetPredicate.BooleanOperator)SimpleSetPredicate.BooleanOperator.IS_IN) && TreeModelCompactor.hasBooleanOperator((Predicate)secondPredicate, (SimpleSetPredicate.BooleanOperator)SimpleSetPredicate.BooleanOperator.IS_IN)) {
                    this.addCategoricalField(secondChild);
                } else {
                    throw new IllegalArgumentException();
                }
            }
            if (update) {
                secondChild.setPredicate((Predicate)True.INSTANCE);
            }
        } else if (score == null) {
            throw new IllegalArgumentException();
        }
    }

    public void exitNode(Node node) {
        Predicate predicate = node.getPredicate();
        if (predicate instanceof True) {
            Node parentNode = this.getParentNode();
            if (parentNode == null) {
                return;
            }
            if (MiningFunction.REGRESSION.equals((Object)this.miningFunction)) {
                TreeModelCompactor.initScore((Node)parentNode, (Node)node);
                TreeModelCompactor.replaceChildWithGrandchildren((Node)parentNode, (Node)node);
            } else if (MiningFunction.CLASSIFICATION.equals((Object)this.miningFunction)) {
                if (node.hasNodes()) {
                    TreeModelCompactor.replaceChildWithGrandchildren((Node)parentNode, (Node)node);
                }
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public void enterTreeModel(TreeModel treeModel) {
        TreeModel.MissingValueStrategy missingValueStrategy = treeModel.getMissingValueStrategy();
        TreeModel.NoTrueChildStrategy noTrueChildStrategy = treeModel.getNoTrueChildStrategy();
        TreeModel.SplitCharacteristic splitCharacteristic = treeModel.getSplitCharacteristic();
        if (!(TreeModel.MissingValueStrategy.NONE.equals((Object)missingValueStrategy) && TreeModel.NoTrueChildStrategy.RETURN_NULL_PREDICTION.equals((Object)noTrueChildStrategy) && TreeModel.SplitCharacteristic.BINARY_SPLIT.equals((Object)splitCharacteristic))) {
            throw new IllegalArgumentException();
        }
        this.miningFunction = treeModel.getMiningFunction();
        this.replacedPredicates.clear();
    }

    public void exitTreeModel(TreeModel treeModel) {
        treeModel.setMissingValueStrategy(TreeModel.MissingValueStrategy.NULL_PREDICTION).setSplitCharacteristic(TreeModel.SplitCharacteristic.MULTI_SPLIT);
        switch (this.miningFunction) {
            case REGRESSION: {
                treeModel.setNoTrueChildStrategy(TreeModel.NoTrueChildStrategy.RETURN_LAST_PREDICTION);
                break;
            }
            case CLASSIFICATION: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.miningFunction = null;
    }

    private boolean isCategoricalField(HasFieldReference<?> hasFieldReference) {
        final FieldName name = hasFieldReference.getField();
        java.util.function.Predicate<Node> predicate = new java.util.function.Predicate<Node>(){

            @Override
            public boolean test(Node node) {
                Predicate predicate = node.getPredicate();
                if (predicate instanceof True) {
                    predicate = (Predicate)TreeModelCompactor.this.replacedPredicates.get(node);
                }
                if (predicate instanceof SimpleSetPredicate) {
                    SimpleSetPredicate simpleSetPredicate = (SimpleSetPredicate)predicate;
                    return TreeModelCompactor.hasFieldReference((Predicate)((Predicate)simpleSetPredicate), (FieldName)name);
                }
                return false;
            }
        };
        Node ancestorNode = this.getAncestorNode(predicate);
        return ancestorNode != null;
    }

    private void addCategoricalField(Node node) {
        this.replacedPredicates.put(node, (SimpleSetPredicate)node.getPredicate());
    }
}

