/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.spark.ml.clustering.KMeansModel;
import org.apache.spark.ml.linalg.Vector;
import org.dmg.pmml.CompareFunction;
import org.dmg.pmml.ComparisonMeasure;
import org.dmg.pmml.Measure;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.SquaredEuclidean;
import org.dmg.pmml.clustering.Cluster;
import org.dmg.pmml.clustering.ClusteringModel;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.clustering.ClusteringModelUtil;
import org.jpmml.sparkml.ClusteringModelConverter;
import org.jpmml.sparkml.VectorUtil;

public class KMeansModelConverter
extends ClusteringModelConverter<KMeansModel> {
    public KMeansModelConverter(KMeansModel model) {
        super(model);
    }

    @Override
    public int getNumberOfClusters() {
        KMeansModel model = (KMeansModel)this.getTransformer();
        return model.getK();
    }

    public ClusteringModel encodeModel(Schema schema) {
        KMeansModel model = (KMeansModel)this.getTransformer();
        ArrayList<Cluster> clusters = new ArrayList<Cluster>();
        Vector[] clusterCenters = model.clusterCenters();
        for (int i = 0; i < clusterCenters.length; ++i) {
            Cluster cluster = new Cluster(PMMLUtil.createRealArray(VectorUtil.toList(clusterCenters[i]))).setId(String.valueOf(i));
            clusters.add(cluster);
        }
        ComparisonMeasure comparisonMeasure = new ComparisonMeasure(ComparisonMeasure.Kind.DISTANCE, (Measure)new SquaredEuclidean()).setCompareFunction(CompareFunction.ABS_DIFF);
        return new ClusteringModel(MiningFunction.CLUSTERING, ClusteringModel.ModelClass.CENTER_BASED, Integer.valueOf(clusters.size()), ModelUtil.createMiningSchema((Label)schema.getLabel()), comparisonMeasure, ClusteringModelUtil.createClusteringFields((List)schema.getFeatures()), clusters);
    }
}

