/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.feature;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import org.apache.spark.ml.feature.OneHotEncoderModel;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.sparkml.BinarizedCategoricalFeature;
import org.jpmml.sparkml.FeatureConverter;
import org.jpmml.sparkml.MultiFeatureConverter;
import org.jpmml.sparkml.SparkMLEncoder;

public class OneHotEncoderModelConverter
extends MultiFeatureConverter<OneHotEncoderModel> {
    public OneHotEncoderModelConverter(OneHotEncoderModel transformer) {
        super(transformer);
    }

    @Override
    public List<Feature> encodeFeatures(SparkMLEncoder encoder) {
        String[] inputCols;
        OneHotEncoderModel transformer = (OneHotEncoderModel)this.getTransformer();
        boolean dropLast = transformer.getDropLast();
        FeatureConverter.InOutMode inputMode = this.getInputMode();
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (String inputCol : inputCols = inputMode.getInputCols(transformer)) {
            CategoricalFeature categoricalFeature = (CategoricalFeature)encoder.getOnlyFeature(inputCol);
            List values = categoricalFeature.getValues();
            List<BinaryFeature> binaryFeatures = OneHotEncoderModelConverter.encodeFeature((PMMLEncoder)encoder, (Feature)categoricalFeature, values, dropLast);
            result.add(new BinarizedCategoricalFeature((PMMLEncoder)encoder, categoricalFeature.getName(), categoricalFeature.getDataType(), binaryFeatures));
        }
        return result;
    }

    @Override
    public void registerFeatures(SparkMLEncoder encoder) {
        OneHotEncoderModel transformer = (OneHotEncoderModel)this.getTransformer();
        List<Feature> features = this.encodeFeatures(encoder);
        FeatureConverter.InOutMode outputMode = this.getOutputMode();
        if (FeatureConverter.InOutMode.SINGLE.equals((Object)outputMode)) {
            String outputCol = transformer.getOutputCol();
            BinarizedCategoricalFeature binarizedCategoricalFeature = (BinarizedCategoricalFeature)((Object)Iterables.getOnlyElement(features));
            encoder.putFeatures(outputCol, binarizedCategoricalFeature.getBinaryFeatures());
        } else if (FeatureConverter.InOutMode.MULTIPLE.equals((Object)outputMode)) {
            String[] outputCols = transformer.getOutputCols();
            if (outputCols.length != features.size()) {
                throw new IllegalArgumentException("Expected " + outputCols.length + " features, got " + features.size() + " features");
            }
            for (int i = 0; i < outputCols.length; ++i) {
                String outputCol = outputCols[i];
                Feature feature = features.get(i);
                BinarizedCategoricalFeature binarizedCategoricalFeature = (BinarizedCategoricalFeature)feature;
                encoder.putFeatures(outputCol, binarizedCategoricalFeature.getBinaryFeatures());
            }
        }
    }

    public static List<BinaryFeature> encodeFeature(PMMLEncoder encoder, Feature feature, List<?> values, boolean dropLast) {
        ArrayList<BinaryFeature> result = new ArrayList<BinaryFeature>();
        if (dropLast) {
            values = values.subList(0, values.size() - 1);
        }
        for (Object value : values) {
            result.add(new BinaryFeature(encoder, feature, value));
        }
        return result;
    }
}

