/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.feature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.spark.ml.feature.StringIndexerModel;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.InvalidValueTreatmentMethod;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Value;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.Decorator;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureUtil;
import org.jpmml.converter.InvalidValueDecorator;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.sparkml.FeatureConverter;
import org.jpmml.sparkml.MultiFeatureConverter;
import org.jpmml.sparkml.SparkMLEncoder;

public class StringIndexerModelConverter
extends MultiFeatureConverter<StringIndexerModel> {
    public StringIndexerModelConverter(StringIndexerModel transformer) {
        super(transformer);
    }

    @Override
    public List<Feature> encodeFeatures(SparkMLEncoder encoder) {
        StringIndexerModel transformer = (StringIndexerModel)this.getTransformer();
        String[][] labelsArray = transformer.labelsArray();
        FeatureConverter.InOutMode inputMode = this.getInputMode();
        ArrayList<Feature> result = new ArrayList<Feature>();
        String[] inputCols = inputMode.getInputCols(transformer);
        for (int i = 0; i < inputCols.length; ++i) {
            String invalidCategory;
            String inputCol = inputCols[i];
            String[] labels = labelsArray[i];
            Feature feature = encoder.getOnlyFeature(inputCol);
            ArrayList<String> categories = new ArrayList<String>();
            categories.addAll(Arrays.asList(labels));
            DataType dataType = feature.getDataType();
            switch (dataType) {
                case INTEGER: 
                case FLOAT: 
                case DOUBLE: {
                    invalidCategory = "-999";
                    break;
                }
                default: {
                    invalidCategory = "__unknown";
                }
            }
            String handleInvalid = transformer.getHandleInvalid();
            Field field = encoder.toCategorical(feature.getName(), categories);
            if (field instanceof DataField) {
                InvalidValueDecorator invalidValueDecorator;
                DataField dataField = (DataField)field;
                switch (handleInvalid) {
                    case "keep": {
                        invalidValueDecorator = new InvalidValueDecorator(InvalidValueTreatmentMethod.AS_IS, (Object)invalidCategory);
                        PMMLUtil.addValues((Field)dataField, Collections.singletonList(invalidCategory), (Value.Property)Value.Property.INVALID);
                        categories.add(invalidCategory);
                        break;
                    }
                    case "error": {
                        invalidValueDecorator = new InvalidValueDecorator(InvalidValueTreatmentMethod.RETURN_INVALID, null);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid value handling strategy " + handleInvalid + " is not supported");
                    }
                }
                encoder.addDecorator(dataField, (Decorator)invalidValueDecorator);
            } else if (field instanceof DerivedField) {
                switch (handleInvalid) {
                    case "keep": {
                        Apply setApply = PMMLUtil.createApply((String)"isIn", (Expression[])new Expression[]{feature.ref()});
                        for (String category : categories) {
                            setApply.addExpressions(new Expression[]{PMMLUtil.createConstant((Object)category, (DataType)dataType)});
                        }
                        categories.add(invalidCategory);
                        Apply apply = PMMLUtil.createApply((String)"if", (Expression[])new Expression[0]).addExpressions(new Expression[]{setApply}).addExpressions(new Expression[]{feature.ref(), PMMLUtil.createConstant((Object)invalidCategory, (DataType)dataType)});
                        field = encoder.createDerivedField(FeatureUtil.createName((String)"handleInvalid", (Feature)feature), OpType.CATEGORICAL, dataType, (Expression)apply);
                        break;
                    }
                    case "error": {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(handleInvalid);
                    }
                }
            } else {
                throw new IllegalArgumentException();
            }
            result.add((Feature)new CategoricalFeature((PMMLEncoder)encoder, field, categories));
        }
        return result;
    }
}

