/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.feature;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.spark.ml.feature.StopWordsRemover;
import org.jpmml.converter.Feature;
import org.jpmml.sparkml.DocumentFeature;
import org.jpmml.sparkml.FeatureConverter;
import org.jpmml.sparkml.MultiFeatureConverter;
import org.jpmml.sparkml.SparkMLEncoder;
import org.jpmml.sparkml.TermUtil;

public class StopWordsRemoverConverter
extends MultiFeatureConverter<StopWordsRemover> {
    public StopWordsRemoverConverter(StopWordsRemover transformer) {
        super(transformer);
    }

    @Override
    public List<Feature> encodeFeatures(SparkMLEncoder encoder) {
        String[] inputCols;
        StopWordsRemover transformer = (StopWordsRemover)this.getTransformer();
        boolean caseSensitive = transformer.getCaseSensitive();
        String[] stopWords = transformer.getStopWords();
        FeatureConverter.InOutMode inputMode = this.getInputMode();
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (String inputCol : inputCols = inputMode.getInputCols(transformer)) {
            DocumentFeature documentFeature = (DocumentFeature)encoder.getOnlyFeature(inputCol);
            Pattern pattern = Pattern.compile(documentFeature.getWordSeparatorRE());
            DocumentFeature.StopWordSet stopWordSet = new DocumentFeature.StopWordSet(caseSensitive);
            for (String stopWord : stopWords) {
                String[] stopTokens = pattern.split(stopWord);
                if (stopTokens.length > 1) continue;
                if (TermUtil.hasPunctuation(stopWord)) {
                    throw new IllegalArgumentException("Punctuated stop words (" + stopWord + ") are not supported");
                }
                stopWordSet.add(stopWord);
            }
            documentFeature.addStopWordSet(stopWordSet);
            result.add((Feature)documentFeature);
        }
        return result;
    }
}

