/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.google.common.io.CharStreams;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.zip.ZipFile;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.dmg.pmml.PMML;
import org.jpmml.model.metro.MetroJAXBUtil;
import org.jpmml.sparkml.PMMLBuilder;
import org.jpmml.sparkml.ZipUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    @Parameter(names={"--help"}, description="Show the list of configuration options and exit", help=true)
    private boolean help = false;
    @Parameter(names={"--schema-input"}, description="Schema JSON input file", required=true)
    private File schemaInput = null;
    @Parameter(names={"--pipeline-input"}, description="Pipeline ML input ZIP file or directory", required=true)
    private File pipelineInput = null;
    @Parameter(names={"--pmml-output"}, description="PMML output file", required=true)
    private File output = null;
    @Parameter(names={"--X-keep_predictionCol"}, arity=1, hidden=true)
    private Boolean keepPredictionCol = Boolean.TRUE;
    @Parameter(names={"--X-compact"}, arity=1, hidden=true)
    private Boolean compact = Boolean.TRUE;
    @Parameter(names={"--X-estimate_featureImportances"}, arity=1, hidden=true)
    private Boolean estimateFeatureImportances = Boolean.FALSE;
    @Parameter(names={"--X-lookup_threshold"}, hidden=true)
    private Integer lookupThreshold = null;
    @Parameter(names={"--X-representation"}, hidden=true)
    private String representation = null;
    private static final Logger logger = LoggerFactory.getLogger(Main.class);

    public static void main(String ... args) throws Exception {
        Main main = new Main();
        JCommander commander = new JCommander((Object)main);
        commander.setProgramName(Main.class.getName());
        try {
            commander.parse(args);
        }
        catch (ParameterException pe) {
            StringBuilder sb = new StringBuilder();
            sb.append(pe.toString());
            sb.append("\n");
            commander.usage(sb);
            System.err.println(sb.toString());
            System.exit(-1);
        }
        if (main.help) {
            StringBuilder sb = new StringBuilder();
            commander.usage(sb);
            System.out.println(sb.toString());
            System.exit(0);
        }
        main.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() throws Exception {
        PMML pmml;
        PipelineModel pipelineModel;
        long end;
        StructType schema;
        try (FileInputStream is = new FileInputStream(this.schemaInput);){
            logger.info("Loading schema..");
            String json = CharStreams.toString((Readable)new InputStreamReader((InputStream)is, "UTF-8"));
            long begin = System.currentTimeMillis();
            schema = (StructType)DataType.fromJson((String)json);
            end = System.currentTimeMillis();
            logger.info("Loaded schema in {} ms.", (Object)(end - begin));
        }
        catch (Exception e) {
            logger.error("Failed to load schema", (Throwable)e);
            throw e;
        }
        try {
            File pipelineDir;
            block39: {
                ZipFile zipFile;
                logger.info("Loading pipeline model..");
                pipelineDir = this.pipelineInput;
                try {
                    zipFile = new ZipFile(pipelineDir);
                }
                catch (IOException ioe) {
                    break block39;
                }
                try {
                    pipelineDir = File.createTempFile("PipelineModel", "");
                    if (!pipelineDir.delete()) {
                        throw new IOException();
                    }
                    pipelineDir.mkdirs();
                    ZipUtil.uncompress(zipFile, pipelineDir);
                }
                finally {
                    zipFile.close();
                }
            }
            long begin = System.currentTimeMillis();
            pipelineModel = PipelineModel.load((String)pipelineDir.getAbsolutePath());
            long end2 = System.currentTimeMillis();
            logger.info("Loaded pipeline model in {} ms.", (Object)(end2 - begin));
        }
        catch (Exception e) {
            logger.error("Failed to load pipeline model", (Throwable)e);
            throw e;
        }
        LinkedHashMap<String, Object> options = new LinkedHashMap<String, Object>();
        options.put("keep_predictionCol", this.keepPredictionCol);
        options.put("compact", this.compact);
        options.put("estimate_featureImportances", this.estimateFeatureImportances);
        options.put("lookup_threshold", this.lookupThreshold);
        options.put("representation", this.representation);
        try {
            logger.info("Converting pipeline model to PMML..");
            long begin = System.currentTimeMillis();
            pmml = new PMMLBuilder(schema, pipelineModel).putOptions(options).build();
            end = System.currentTimeMillis();
            logger.info("Converted pipeline to PMML in {} ms.", (Object)(end - begin));
        }
        catch (Exception e) {
            logger.info("Failed to convert pipeline to PMML", (Throwable)e);
            throw e;
        }
        try (FileOutputStream os = new FileOutputStream(this.output);){
            logger.info("Marshalling PMML..");
            long begin = System.currentTimeMillis();
            MetroJAXBUtil.marshalPMML((PMML)pmml, (OutputStream)os);
            long end3 = System.currentTimeMillis();
            logger.info("Marshalled PMML in {} ms.", (Object)(end3 - begin));
        }
        catch (Exception e) {
            logger.error("Failed to marshal PMML", (Throwable)e);
            throw e;
        }
    }

    public File getSchemaInput() {
        return this.schemaInput;
    }

    public void setSchemaInput(File schemaInput) {
        this.schemaInput = schemaInput;
    }

    public File getPipelineInput() {
        return this.pipelineInput;
    }

    public void setPipelineInput(File pipelineInput) {
        this.pipelineInput = pipelineInput;
    }

    public File getOutput() {
        return this.output;
    }

    public void setOutput(File output) {
        this.output = output;
    }
}

