/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml;

import java.util.ArrayList;
import java.util.Objects;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.OpType;
import org.dmg.pmml.ParameterField;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FieldNameUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.model.ToStringHelper;
import org.jpmml.sparkml.WeightedTermFeature;

public class TermFeature
extends Feature {
    private DefineFunction defineFunction = null;
    private Feature feature = null;
    private String value = null;

    public TermFeature(PMMLEncoder encoder, DefineFunction defineFunction, Feature feature, String value) {
        super(encoder, FieldNameUtil.create((String)defineFunction.getName(), (Object[])new Object[]{value}), defineFunction.getDataType());
        this.setDefineFunction(defineFunction);
        this.setFeature(feature);
        this.setValue(value);
    }

    public ContinuousFeature toContinuousFeature() {
        return this.toContinuousFeature(this.getName(), this.getDataType(), () -> this.createApply());
    }

    public WeightedTermFeature toWeightedTermFeature(Number weight) {
        DefineFunction defineFunction;
        String name;
        PMMLEncoder encoder = this.getEncoder();
        DefineFunction weightedDefineFunction = encoder.getDefineFunction(name = (defineFunction = this.getDefineFunction()).getName().replace("tf@", "tf-idf@"));
        if (weightedDefineFunction == null) {
            ParameterField weightField = new ParameterField(FieldName.create((String)"weight"));
            ArrayList<ParameterField> weightedParameterFields = new ArrayList<ParameterField>(defineFunction.getParameterFields());
            weightedParameterFields.add(weightField);
            Apply apply = PMMLUtil.createApply((String)"*", (Expression[])new Expression[]{defineFunction.getExpression(), new FieldRef(weightField.getName())});
            weightedDefineFunction = new DefineFunction(name, OpType.CONTINUOUS, DataType.DOUBLE, weightedParameterFields, (Expression)apply);
            encoder.addDefineFunction(weightedDefineFunction);
        }
        return new WeightedTermFeature(encoder, weightedDefineFunction, this.getFeature(), this.getValue(), weight);
    }

    public Apply createApply() {
        DefineFunction defineFunction = this.getDefineFunction();
        Feature feature = this.getFeature();
        String value = this.getValue();
        Constant constant = PMMLUtil.createConstant((Object)value, (DataType)DataType.STRING);
        return PMMLUtil.createApply((String)defineFunction.getName(), (Expression[])new Expression[]{feature.ref(), constant});
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.getDefineFunction());
        result = 31 * result + Objects.hashCode(this.getFeature());
        result = 31 * result + Objects.hashCode(this.getValue());
        return result;
    }

    public boolean equals(Object object) {
        if (object instanceof TermFeature) {
            TermFeature that = (TermFeature)((Object)object);
            return super.equals(object) && Objects.equals(this.getDefineFunction(), that.getDefineFunction()) && Objects.equals(this.getFeature(), that.getFeature()) && Objects.equals(this.getValue(), that.getValue());
        }
        return false;
    }

    protected ToStringHelper toStringHelper() {
        return super.toStringHelper().add("defineFunction", (Object)this.getDefineFunction()).add("feature", (Object)this.getFeature()).add("value", (Object)this.getValue());
    }

    public DefineFunction getDefineFunction() {
        return this.defineFunction;
    }

    private void setDefineFunction(DefineFunction defineFunction) {
        this.defineFunction = Objects.requireNonNull(defineFunction);
    }

    public Feature getFeature() {
        return this.feature;
    }

    private void setFeature(Feature feature) {
        this.feature = Objects.requireNonNull(feature);
    }

    public String getValue() {
        return this.value;
    }

    private void setValue(String value) {
        this.value = Objects.requireNonNull(value);
    }
}

