/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.feature;

import java.util.ArrayList;
import java.util.List;
import org.apache.spark.ml.feature.SQLTransformer;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.types.StructType;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.VisitorAction;
import org.jpmml.converter.BooleanFeature;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.StringFeature;
import org.jpmml.model.visitors.AbstractVisitor;
import org.jpmml.sparkml.DatasetUtil;
import org.jpmml.sparkml.ExpressionTranslator;
import org.jpmml.sparkml.FeatureConverter;
import org.jpmml.sparkml.SparkMLEncoder;
import scala.collection.JavaConversions;
import scala.collection.Seq;

public class SQLTransformerConverter
extends FeatureConverter<SQLTransformer> {
    public SQLTransformerConverter(SQLTransformer sqlTransformer) {
        super(sqlTransformer);
    }

    @Override
    public List<Feature> encodeFeatures(final SparkMLEncoder encoder) {
        SQLTransformer transformer = (SQLTransformer)this.getTransformer();
        String statement = transformer.getStatement();
        SparkSession sparkSession = SparkSession.builder().getOrCreate();
        StructType schema = encoder.getSchema();
        LogicalPlan logicalPlan = DatasetUtil.createAnalyzedLogicalPlan(sparkSession, schema, statement);
        ArrayList<Feature> result = new ArrayList<Feature>();
        List expressions = JavaConversions.seqAsJavaList((Seq)logicalPlan.expressions());
        for (org.apache.spark.sql.catalyst.expressions.Expression expression : expressions) {
            StringFeature feature;
            OpType opType;
            String name;
            DataType dataType = DatasetUtil.translateDataType(expression.dataType());
            if (expression instanceof Alias) {
                Alias alias = (Alias)expression;
                expression = alias.child();
                name = alias.name();
            } else {
                name = "sql(" + expression.toString() + ")";
            }
            switch (dataType) {
                case STRING: {
                    opType = OpType.CATEGORICAL;
                    break;
                }
                case INTEGER: 
                case DOUBLE: {
                    opType = OpType.CONTINUOUS;
                    break;
                }
                case BOOLEAN: {
                    opType = OpType.CATEGORICAL;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Data type " + dataType + " is not supported");
                }
            }
            Expression pmmlExpression = ExpressionTranslator.translate(expression);
            AbstractVisitor visitor = new AbstractVisitor(){

                public VisitorAction visit(FieldRef fieldRef) {
                    FieldName name = fieldRef.getField();
                    encoder.getOnlyFeature(name.getValue());
                    return super.visit(fieldRef);
                }
            };
            visitor.applyTo((Visitable)pmmlExpression);
            DerivedField derivedField = encoder.createDerivedField(FieldName.create((String)name), opType, dataType, pmmlExpression);
            switch (dataType) {
                case STRING: {
                    feature = new StringFeature((PMMLEncoder)encoder, (Field)derivedField);
                    break;
                }
                case INTEGER: 
                case DOUBLE: {
                    feature = new ContinuousFeature((PMMLEncoder)encoder, (Field)derivedField);
                    break;
                }
                case BOOLEAN: {
                    feature = new BooleanFeature((PMMLEncoder)encoder, (Field)derivedField);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Data type " + dataType + " is not supported");
                }
            }
            encoder.putOnlyFeature(name, (Feature)feature);
            result.add((Feature)feature);
        }
        return result;
    }

    @Override
    public void registerFeatures(SparkMLEncoder encoder) {
        this.encodeFeatures(encoder);
    }
}

