/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml;

import java.util.List;
import org.apache.spark.ml.PredictionModel;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.jpmml.converter.Feature;
import org.jpmml.converter.SchemaUtil;
import org.jpmml.sparkml.ModelConverter;
import org.jpmml.sparkml.SparkMLEncoder;

public abstract class PredictionModelConverter<T extends PredictionModel<Vector, T> & HasPredictionCol>
extends ModelConverter<T> {
    public PredictionModelConverter(T model) {
        super(model);
    }

    @Override
    public List<Feature> getFeatures(SparkMLEncoder encoder) {
        PredictionModel model = (PredictionModel)this.getTransformer();
        String featuresCol = model.getFeaturesCol();
        List<Feature> features = encoder.getFeatures(featuresCol);
        int numFeatures = model.numFeatures();
        if (numFeatures != -1) {
            SchemaUtil.checkSize((int)numFeatures, features);
        }
        return features;
    }
}

