/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml;

import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipUtil {
    private ZipUtil() {
    }

    public static void uncompress(File file, File dir) throws IOException {
        try (ZipFile zipFile = new ZipFile(file);){
            ZipUtil.uncompress(zipFile, dir);
        }
    }

    public static void uncompress(ZipFile zipFile, File dir) throws IOException {
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            InputStream is = zipFile.getInputStream(entry);
            Throwable throwable = null;
            try {
                File file = new File(dir, entry.getName());
                File parentDir = file.getParentFile();
                if (!parentDir.exists() && !parentDir.mkdirs()) {
                    throw new IOException(parentDir.getAbsolutePath());
                }
                FileOutputStream os = new FileOutputStream(file);
                Throwable throwable2 = null;
                try {
                    ByteStreams.copy((InputStream)is, (OutputStream)os);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (os == null) continue;
                    if (throwable2 != null) {
                        try {
                            ((OutputStream)os).close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    ((OutputStream)os).close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                is.close();
            }
        }
    }
}

