/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.model;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.OpType;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FieldNameUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.SchemaUtil;
import org.jpmml.sparkml.ModelConverter;

public class RegressionTableUtil {
    private RegressionTableUtil() {
    }

    public static <C extends ModelConverter<?>> void simplify(C converter, Object identifier, List<Feature> features, List<Double> coefficients) {
        SchemaUtil.checkSize((int)coefficients.size(), features);
        Integer lookupThreshold = (Integer)converter.getOption("lookup_threshold", null);
        if (lookupThreshold == null) {
            return;
        }
        Map<FieldName, Long> countMap = features.stream().filter(feature -> feature instanceof BinaryFeature).collect(Collectors.groupingBy(feature -> ((BinaryFeature)feature).getName(), Collectors.counting()));
        Set<Map.Entry<FieldName, Long>> entries = countMap.entrySet();
        for (Map.Entry entry : entries) {
            if ((Long)entry.getValue() < (long)lookupThreshold.intValue()) continue;
            RegressionTableUtil.createMapValues((FieldName)entry.getKey(), identifier, features, coefficients);
        }
    }

    private static MapValues createMapValues(FieldName name, Object identifier, List<Feature> features, List<Double> coefficients) {
        ListIterator<Feature> featureIt = features.listIterator();
        ListIterator<Double> coefficientIt = coefficients.listIterator();
        PMMLEncoder encoder = null;
        ArrayList<Object> inputValues = new ArrayList<Object>();
        ArrayList<Double> outputValues = new ArrayList<Double>();
        while (featureIt.hasNext()) {
            BinaryFeature binaryFeature;
            Feature feature = featureIt.next();
            Double coefficient = coefficientIt.next();
            if (!(feature instanceof BinaryFeature) || !name.equals((Object)(binaryFeature = (BinaryFeature)feature).getName())) continue;
            featureIt.remove();
            coefficientIt.remove();
            if (encoder == null) {
                encoder = binaryFeature.getEncoder();
            }
            inputValues.add(binaryFeature.getValue());
            outputValues.add(coefficient);
        }
        MapValues mapValues = PMMLUtil.createMapValues((FieldName)name, inputValues, outputValues).setDefaultValue((Object)0.0).setDataType(DataType.DOUBLE);
        DerivedField derivedField = encoder.createDerivedField(identifier != null ? FieldNameUtil.create((String)"lookup", (Object[])new Object[]{name, identifier}) : FieldNameUtil.create((String)"lookup", (Object[])new Object[]{name}), OpType.CONTINUOUS, DataType.DOUBLE, (Expression)mapValues);
        featureIt.add((Feature)new ContinuousFeature(encoder, (Field)derivedField));
        coefficientIt.add(1.0);
        return mapValues;
    }
}

