/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml;

import java.util.Collections;
import java.util.List;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.param.shared.HasFeaturesCol;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.OpType;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.ResultFeature;
import org.jpmml.converter.DerivedOutputField;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FieldNameUtil;
import org.jpmml.converter.IndexFeature;
import org.jpmml.converter.Label;
import org.jpmml.converter.LabelUtil;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.sparkml.ModelConverter;
import org.jpmml.sparkml.SparkMLEncoder;

public abstract class ClusteringModelConverter<T extends Model<T> & HasPredictionCol>
extends ModelConverter<T> {
    public ClusteringModelConverter(T model) {
        super(model);
    }

    public abstract int getNumberOfClusters();

    @Override
    public MiningFunction getMiningFunction() {
        return MiningFunction.CLUSTERING;
    }

    @Override
    public List<Feature> getFeatures(SparkMLEncoder encoder) {
        Model model = (Model)this.getTransformer();
        String featuresCol = ((HasFeaturesCol)model).getFeaturesCol();
        return encoder.getFeatures(featuresCol);
    }

    @Override
    public List<OutputField> registerOutputFields(Label label, org.dmg.pmml.Model pmmlModel, SparkMLEncoder encoder) {
        Model model = (Model)this.getTransformer();
        List clusters = LabelUtil.createTargetCategories((int)this.getNumberOfClusters());
        String predictionCol = ((HasPredictionCol)model).getPredictionCol();
        OutputField pmmlPredictedOutputField = ModelUtil.createPredictedField((FieldName)FieldNameUtil.create((String)"pmml", (Object[])new Object[]{predictionCol}), (OpType)OpType.CATEGORICAL, (DataType)DataType.STRING).setFinalResult(Boolean.valueOf(false));
        DerivedOutputField pmmlPredictedField = encoder.createDerivedField(pmmlModel, pmmlPredictedOutputField, true);
        OutputField predictedOutputField = new OutputField(FieldName.create((String)predictionCol), OpType.CATEGORICAL, DataType.INTEGER).setResultFeature(ResultFeature.TRANSFORMED_VALUE).setExpression((Expression)new FieldRef(pmmlPredictedField.getName()));
        DerivedOutputField predictedField = encoder.createDerivedField(pmmlModel, predictedOutputField, true);
        encoder.putOnlyFeature(predictionCol, (Feature)new IndexFeature((PMMLEncoder)encoder, (Field)predictedField, clusters));
        return Collections.emptyList();
    }
}

