/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.spark.sql.catalyst.expressions.Abs;
import org.apache.spark.sql.catalyst.expressions.Acos;
import org.apache.spark.sql.catalyst.expressions.Add;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.Asin;
import org.apache.spark.sql.catalyst.expressions.Atan;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.BinaryArithmetic;
import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.BinaryMathExpression;
import org.apache.spark.sql.catalyst.expressions.BinaryOperator;
import org.apache.spark.sql.catalyst.expressions.CaseWhen;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Ceil;
import org.apache.spark.sql.catalyst.expressions.Concat;
import org.apache.spark.sql.catalyst.expressions.Cos;
import org.apache.spark.sql.catalyst.expressions.Cosh;
import org.apache.spark.sql.catalyst.expressions.Divide;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Exp;
import org.apache.spark.sql.catalyst.expressions.Expm1;
import org.apache.spark.sql.catalyst.expressions.Floor;
import org.apache.spark.sql.catalyst.expressions.GreaterThan;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Greatest;
import org.apache.spark.sql.catalyst.expressions.Hypot;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.IsNaN;
import org.apache.spark.sql.catalyst.expressions.IsNotNull;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.Least;
import org.apache.spark.sql.catalyst.expressions.Length;
import org.apache.spark.sql.catalyst.expressions.LessThan;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Log;
import org.apache.spark.sql.catalyst.expressions.Log10;
import org.apache.spark.sql.catalyst.expressions.Log1p;
import org.apache.spark.sql.catalyst.expressions.Lower;
import org.apache.spark.sql.catalyst.expressions.Multiply;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.catalyst.expressions.Pow;
import org.apache.spark.sql.catalyst.expressions.RLike;
import org.apache.spark.sql.catalyst.expressions.RegExpReplace;
import org.apache.spark.sql.catalyst.expressions.Rint;
import org.apache.spark.sql.catalyst.expressions.Sin;
import org.apache.spark.sql.catalyst.expressions.Sinh;
import org.apache.spark.sql.catalyst.expressions.Sqrt;
import org.apache.spark.sql.catalyst.expressions.StringTrim;
import org.apache.spark.sql.catalyst.expressions.Substring;
import org.apache.spark.sql.catalyst.expressions.Subtract;
import org.apache.spark.sql.catalyst.expressions.Tan;
import org.apache.spark.sql.catalyst.expressions.Tanh;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryMinus;
import org.apache.spark.sql.catalyst.expressions.UnaryPositive;
import org.apache.spark.sql.catalyst.expressions.Upper;
import org.apache.spark.sql.types.Decimal;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.HasDataType;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Visitable;
import org.jpmml.converter.FieldNameUtil;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.converter.visitors.ExpressionCompactor;
import org.jpmml.sparkml.AliasExpression;
import org.jpmml.sparkml.DatasetUtil;
import org.jpmml.sparkml.ExpressionUtil;
import org.jpmml.sparkml.SparkMLEncoder;
import scala.Option;
import scala.Tuple2;
import scala.collection.JavaConversions;
import scala.collection.Seq;

public class ExpressionTranslator {
    private SparkMLEncoder encoder = null;
    private static final Package javaLangPackage = Package.getPackage("java.lang");
    private static final int MAX_STRING_LENGTH = 65536;

    private ExpressionTranslator(SparkMLEncoder encoder) {
        this.setEncoder(encoder);
    }

    public SparkMLEncoder getEncoder() {
        return this.encoder;
    }

    private void setEncoder(SparkMLEncoder encoder) {
        this.encoder = Objects.requireNonNull(encoder);
    }

    public static Expression translate(SparkMLEncoder encoder, org.apache.spark.sql.catalyst.expressions.Expression expression) {
        return ExpressionTranslator.translate(encoder, expression, true);
    }

    public static Expression translate(SparkMLEncoder encoder, org.apache.spark.sql.catalyst.expressions.Expression expression, boolean compact) {
        ExpressionTranslator expressionTranslator = new ExpressionTranslator(encoder);
        Expression pmmlExpression = expressionTranslator.translateInternal(expression);
        if (compact) {
            ExpressionCompactor expressionCompactor = new ExpressionCompactor();
            expressionCompactor.applyTo((Visitable)pmmlExpression);
        }
        return pmmlExpression;
    }

    private Expression translateInternal(org.apache.spark.sql.catalyst.expressions.Expression expression) {
        SparkMLEncoder encoder = this.getEncoder();
        if (expression instanceof Alias) {
            Alias alias = (Alias)expression;
            String name = alias.name();
            org.apache.spark.sql.catalyst.expressions.Expression child = alias.child();
            Expression pmmlExpression = this.translateInternal(child);
            return new AliasExpression(name, pmmlExpression);
        }
        if (expression instanceof AttributeReference) {
            AttributeReference attributeReference = (AttributeReference)expression;
            String name = attributeReference.name();
            return new FieldRef(FieldName.create((String)name));
        }
        if (expression instanceof BinaryMathExpression) {
            String function;
            BinaryMathExpression binaryMathExpression = (BinaryMathExpression)expression;
            org.apache.spark.sql.catalyst.expressions.Expression left = binaryMathExpression.left();
            org.apache.spark.sql.catalyst.expressions.Expression right = binaryMathExpression.right();
            if (binaryMathExpression instanceof Hypot) {
                function = "hypot";
            } else if (binaryMathExpression instanceof Pow) {
                function = "pow";
            } else {
                throw new IllegalArgumentException(ExpressionTranslator.formatMessage((org.apache.spark.sql.catalyst.expressions.Expression)binaryMathExpression));
            }
            return PMMLUtil.createApply((String)function, (Expression[])new Expression[]{this.translateInternal(left), this.translateInternal(right)});
        }
        if (expression instanceof BinaryOperator) {
            String function;
            BinaryOperator binaryOperator = (BinaryOperator)expression;
            String symbol = binaryOperator.symbol();
            org.apache.spark.sql.catalyst.expressions.Expression left = binaryOperator.left();
            org.apache.spark.sql.catalyst.expressions.Expression right = binaryOperator.right();
            if (expression instanceof And || expression instanceof Or) {
                switch (symbol) {
                    case "&&": {
                        function = "and";
                        break;
                    }
                    case "||": {
                        function = "or";
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(ExpressionTranslator.formatMessage((org.apache.spark.sql.catalyst.expressions.Expression)binaryOperator));
                    }
                }
            } else if (expression instanceof Add || expression instanceof Divide || expression instanceof Multiply || expression instanceof Subtract) {
                BinaryArithmetic binaryArithmetic = (BinaryArithmetic)binaryOperator;
                switch (symbol) {
                    case "+": {
                        function = "+";
                        break;
                    }
                    case "/": {
                        function = "/";
                        break;
                    }
                    case "*": {
                        function = "*";
                        break;
                    }
                    case "-": {
                        function = "-";
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(ExpressionTranslator.formatMessage((org.apache.spark.sql.catalyst.expressions.Expression)binaryArithmetic));
                    }
                }
            } else if (expression instanceof EqualTo || expression instanceof GreaterThan || expression instanceof GreaterThanOrEqual || expression instanceof LessThan || expression instanceof LessThanOrEqual) {
                BinaryComparison binaryComparison = (BinaryComparison)binaryOperator;
                switch (symbol) {
                    case "=": {
                        function = "equal";
                        break;
                    }
                    case ">": {
                        function = "greaterThan";
                        break;
                    }
                    case ">=": {
                        function = "greaterOrEqual";
                        break;
                    }
                    case "<": {
                        function = "lessThan";
                        break;
                    }
                    case "<=": {
                        function = "lessOrEqual";
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(ExpressionTranslator.formatMessage((org.apache.spark.sql.catalyst.expressions.Expression)binaryComparison));
                    }
                }
            } else {
                throw new IllegalArgumentException(ExpressionTranslator.formatMessage((org.apache.spark.sql.catalyst.expressions.Expression)binaryOperator));
            }
            return PMMLUtil.createApply((String)function, (Expression[])new Expression[]{this.translateInternal(left), this.translateInternal(right)});
        }
        if (expression instanceof CaseWhen) {
            CaseWhen caseWhen = (CaseWhen)expression;
            List branches = JavaConversions.seqAsJavaList((Seq)caseWhen.branches());
            Option elseValue = caseWhen.elseValue();
            Apply apply = null;
            Iterator branchIt = branches.iterator();
            Apply prevBranchApply = null;
            do {
                Tuple2 branch = (Tuple2)branchIt.next();
                org.apache.spark.sql.catalyst.expressions.Expression predicate = (org.apache.spark.sql.catalyst.expressions.Expression)branch._1();
                org.apache.spark.sql.catalyst.expressions.Expression value = (org.apache.spark.sql.catalyst.expressions.Expression)branch._2();
                Apply branchApply = PMMLUtil.createApply((String)"if", (Expression[])new Expression[]{this.translateInternal(predicate), this.translateInternal(value)});
                if (apply == null) {
                    apply = branchApply;
                }
                if (prevBranchApply != null) {
                    prevBranchApply.addExpressions(new Expression[]{branchApply});
                }
                prevBranchApply = branchApply;
            } while (branchIt.hasNext());
            if (elseValue.isDefined()) {
                org.apache.spark.sql.catalyst.expressions.Expression value = (org.apache.spark.sql.catalyst.expressions.Expression)elseValue.get();
                prevBranchApply.addExpressions(new Expression[]{this.translateInternal(value)});
            }
            return apply;
        }
        if (expression instanceof Cast) {
            FieldName name;
            Cast cast = (Cast)expression;
            org.apache.spark.sql.catalyst.expressions.Expression child = cast.child();
            Expression pmmlExpression = this.translateInternal(child);
            DataType dataType = DatasetUtil.translateDataType(cast.dataType());
            if (pmmlExpression instanceof HasDataType) {
                HasDataType hasDataType = (HasDataType)pmmlExpression;
                hasDataType.setDataType(dataType);
                return pmmlExpression;
            }
            if (pmmlExpression instanceof AliasExpression) {
                AliasExpression aliasExpression = (AliasExpression)pmmlExpression;
                name = FieldName.create((String)aliasExpression.getName());
            } else {
                name = FieldNameUtil.create((DataType)dataType, (Object[])new Object[]{ExpressionUtil.format(child)});
            }
            OpType opType = ExpressionUtil.getOpType(dataType);
            pmmlExpression = AliasExpression.unwrap(pmmlExpression);
            DerivedField derivedField = encoder.createDerivedField(name, opType, dataType, pmmlExpression);
            return new FieldRef(derivedField.getName());
        }
        if (expression instanceof Concat) {
            Concat concat = (Concat)expression;
            List children = JavaConversions.seqAsJavaList((Seq)concat.children());
            Apply apply = PMMLUtil.createApply((String)"concat", (Expression[])new Expression[0]);
            for (org.apache.spark.sql.catalyst.expressions.Expression child : children) {
                apply.addExpressions(new Expression[]{this.translateInternal(child)});
            }
            return apply;
        }
        if (expression instanceof Greatest) {
            Greatest greatest = (Greatest)expression;
            List children = JavaConversions.seqAsJavaList((Seq)greatest.children());
            Apply apply = PMMLUtil.createApply((String)"max", (Expression[])new Expression[0]);
            for (org.apache.spark.sql.catalyst.expressions.Expression child : children) {
                apply.addExpressions(new Expression[]{this.translateInternal(child)});
            }
            return apply;
        }
        if (expression instanceof If) {
            If _if = (If)expression;
            org.apache.spark.sql.catalyst.expressions.Expression predicate = _if.predicate();
            org.apache.spark.sql.catalyst.expressions.Expression trueValue = _if.trueValue();
            org.apache.spark.sql.catalyst.expressions.Expression falseValue = _if.falseValue();
            return PMMLUtil.createApply((String)"if", (Expression[])new Expression[]{this.translateInternal(predicate), this.translateInternal(trueValue), this.translateInternal(falseValue)});
        }
        if (expression instanceof In) {
            In in = (In)expression;
            org.apache.spark.sql.catalyst.expressions.Expression value = in.value();
            List elements = JavaConversions.seqAsJavaList((Seq)in.list());
            Apply apply = PMMLUtil.createApply((String)"isIn", (Expression[])new Expression[]{this.translateInternal(value)});
            for (org.apache.spark.sql.catalyst.expressions.Expression element : elements) {
                apply.addExpressions(new Expression[]{this.translateInternal(element)});
            }
            return apply;
        }
        if (expression instanceof Least) {
            Least least = (Least)expression;
            List children = JavaConversions.seqAsJavaList((Seq)least.children());
            Apply apply = PMMLUtil.createApply((String)"min", (Expression[])new Expression[0]);
            for (org.apache.spark.sql.catalyst.expressions.Expression child : children) {
                apply.addExpressions(new Expression[]{this.translateInternal(child)});
            }
            return apply;
        }
        if (expression instanceof Length) {
            Length length = (Length)expression;
            org.apache.spark.sql.catalyst.expressions.Expression child = length.child();
            return PMMLUtil.createApply((String)"stringLength", (Expression[])new Expression[]{this.translateInternal(child)});
        }
        if (expression instanceof Literal) {
            DataType dataType;
            Literal literal = (Literal)expression;
            Object value = literal.value();
            if (value == null) {
                return PMMLUtil.createMissingConstant();
            }
            if (value instanceof Decimal) {
                Decimal decimal = (Decimal)value;
                dataType = DataType.STRING;
                value = decimal.toString();
            } else {
                dataType = DatasetUtil.translateDataType(literal.dataType());
                value = ExpressionTranslator.toSimpleObject(value);
            }
            return PMMLUtil.createConstant((Object)value, (DataType)dataType);
        }
        if (expression instanceof RegExpReplace) {
            RegExpReplace regexpReplace = (RegExpReplace)expression;
            org.apache.spark.sql.catalyst.expressions.Expression subject = regexpReplace.subject();
            org.apache.spark.sql.catalyst.expressions.Expression regexp = regexpReplace.regexp();
            org.apache.spark.sql.catalyst.expressions.Expression rep = regexpReplace.rep();
            return PMMLUtil.createApply((String)"replace", (Expression[])new Expression[]{this.translateInternal(subject), this.translateInternal(regexp), this.translateInternal(rep)});
        }
        if (expression instanceof RLike) {
            RLike rlike = (RLike)expression;
            org.apache.spark.sql.catalyst.expressions.Expression left = rlike.left();
            org.apache.spark.sql.catalyst.expressions.Expression right = rlike.right();
            return PMMLUtil.createApply((String)"matches", (Expression[])new Expression[]{this.translateInternal(left), this.translateInternal(right)});
        }
        if (expression instanceof StringTrim) {
            StringTrim stringTrim = (StringTrim)expression;
            org.apache.spark.sql.catalyst.expressions.Expression srcStr = stringTrim.srcStr();
            Option trimStr = stringTrim.trimStr();
            if (trimStr.isDefined()) {
                throw new IllegalArgumentException();
            }
            return PMMLUtil.createApply((String)"trimBlanks", (Expression[])new Expression[]{this.translateInternal(srcStr)});
        }
        if (expression instanceof Substring) {
            Substring substring = (Substring)expression;
            org.apache.spark.sql.catalyst.expressions.Expression str = substring.str();
            Literal pos = (Literal)substring.pos();
            Literal len = (Literal)substring.len();
            int posValue = ValueUtil.asInt((Number)((Number)pos.value()));
            if (posValue <= 0) {
                throw new IllegalArgumentException("Expected absolute start position, got relative start position " + pos);
            }
            int lenValue = ValueUtil.asInt((Number)((Number)len.value()));
            lenValue = Math.min(lenValue, 65536);
            return PMMLUtil.createApply((String)"substring", (Expression[])new Expression[]{this.translateInternal(str), PMMLUtil.createConstant((Number)posValue), PMMLUtil.createConstant((Number)lenValue)});
        }
        if (expression instanceof UnaryExpression) {
            UnaryExpression unaryExpression = (UnaryExpression)expression;
            org.apache.spark.sql.catalyst.expressions.Expression child = unaryExpression.child();
            if (expression instanceof Abs) {
                return PMMLUtil.createApply((String)"abs", (Expression[])new Expression[]{this.translateInternal(child)});
            }
            if (expression instanceof Acos) {
                return PMMLUtil.createApply((String)"acos", (Expression[])new Expression[]{this.translateInternal(child)});
            }
            if (expression instanceof Asin) {
                return PMMLUtil.createApply((String)"asin", (Expression[])new Expression[]{this.translateInternal(child)});
            }
            if (expression instanceof Atan) {
                return PMMLUtil.createApply((String)"atan", (Expression[])new Expression[]{this.translateInternal(child)});
            }
            if (expression instanceof Ceil) {
                return PMMLUtil.createApply((String)"ceil", (Expression[])new Expression[]{this.translateInternal(child)});
            }
            if (expression instanceof Cos) {
                return PMMLUtil.createApply((String)"cos", (Expression[])new Expression[]{this.translateInternal(child)});
            }
            if (expression instanceof Cosh) {
                return PMMLUtil.createApply((String)"cosh", (Expression[])new Expression[]{this.translateInternal(child)});
            }
            if (expression instanceof Exp) {
                return PMMLUtil.createApply((String)"exp", (Expression[])new Expression[]{this.translateInternal(child)});
            }
            if (expression instanceof Expm1) {
                return PMMLUtil.createApply((String)"expm1", (Expression[])new Expression[]{this.translateInternal(child)});
            }
            if (expression instanceof Floor) {
                return PMMLUtil.createApply((String)"floor", (Expression[])new Expression[]{this.translateInternal(child)});
            }
            if (expression instanceof Log) {
                return PMMLUtil.createApply((String)"ln", (Expression[])new Expression[]{this.translateInternal(child)});
            }
            if (expression instanceof Log10) {
                return PMMLUtil.createApply((String)"log10", (Expression[])new Expression[]{this.translateInternal(child)});
            }
            if (expression instanceof Log1p) {
                return PMMLUtil.createApply((String)"ln1p", (Expression[])new Expression[]{this.translateInternal(child)});
            }
            if (expression instanceof Lower) {
                return PMMLUtil.createApply((String)"lowercase", (Expression[])new Expression[]{this.translateInternal(child)});
            }
            if (expression instanceof IsNaN) {
                return PMMLUtil.createApply((String)"isNotValid", (Expression[])new Expression[]{this.translateInternal(child)});
            }
            if (expression instanceof IsNotNull) {
                return PMMLUtil.createApply((String)"isNotMissing", (Expression[])new Expression[]{this.translateInternal(child)});
            }
            if (expression instanceof IsNull) {
                return PMMLUtil.createApply((String)"isMissing", (Expression[])new Expression[]{this.translateInternal(child)});
            }
            if (expression instanceof Not) {
                return PMMLUtil.createApply((String)"not", (Expression[])new Expression[]{this.translateInternal(child)});
            }
            if (expression instanceof Rint) {
                return PMMLUtil.createApply((String)"rint", (Expression[])new Expression[]{this.translateInternal(child)});
            }
            if (expression instanceof Sin) {
                return PMMLUtil.createApply((String)"sin", (Expression[])new Expression[]{this.translateInternal(child)});
            }
            if (expression instanceof Sinh) {
                return PMMLUtil.createApply((String)"sinh", (Expression[])new Expression[]{this.translateInternal(child)});
            }
            if (expression instanceof Sqrt) {
                return PMMLUtil.createApply((String)"sqrt", (Expression[])new Expression[]{this.translateInternal(child)});
            }
            if (expression instanceof Tan) {
                return PMMLUtil.createApply((String)"tan", (Expression[])new Expression[]{this.translateInternal(child)});
            }
            if (expression instanceof Tanh) {
                return PMMLUtil.createApply((String)"tanh", (Expression[])new Expression[]{this.translateInternal(child)});
            }
            if (expression instanceof UnaryMinus) {
                return PMMLUtil.toNegative((Expression)this.translateInternal(child));
            }
            if (expression instanceof UnaryPositive) {
                return this.translateInternal(child);
            }
            if (expression instanceof Upper) {
                return PMMLUtil.createApply((String)"uppercase", (Expression[])new Expression[]{this.translateInternal(child)});
            }
            throw new IllegalArgumentException(ExpressionTranslator.formatMessage((org.apache.spark.sql.catalyst.expressions.Expression)unaryExpression));
        }
        throw new IllegalArgumentException(ExpressionTranslator.formatMessage(expression));
    }

    private static Object toSimpleObject(Object value) {
        Class<?> clazz = value.getClass();
        if (!javaLangPackage.equals(clazz.getPackage())) {
            return value.toString();
        }
        return value;
    }

    private static String formatMessage(org.apache.spark.sql.catalyst.expressions.Expression expression) {
        if (expression == null) {
            return null;
        }
        return "Spark SQL function '" + ExpressionUtil.format(expression) + "' (class " + expression.getClass().getName() + ") is not supported";
    }
}

