/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JOp;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.Arrays;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.UnsupportedAttributeException;
import org.jpmml.translator.ArrayEncoder;
import org.jpmml.translator.Encoder;
import org.jpmml.translator.FieldInfo;
import org.jpmml.translator.FieldValueRef;
import org.jpmml.translator.JVarRef;
import org.jpmml.translator.MethodScope;
import org.jpmml.translator.TermFrequencyEncoder;
import org.jpmml.translator.TranslationContext;

public class ArgumentsRef
extends JVarRef {
    public ArgumentsRef(JVar variable) {
        super(variable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JMethod getMethod(FieldInfo fieldInfo, TranslationContext context) {
        JMethod encoderMethod;
        String memberName;
        JCodeModel codeModel = context.getCodeModel();
        JDefinedClass argumentsClazz = (JDefinedClass)this.type();
        Field<?> field = fieldInfo.getField();
        Encoder encoder = fieldInfo.getEncoder();
        FieldName name = field.getName();
        JType[] argTypes = new JType[]{};
        if (encoder != null) {
            FieldInfo finalFieldInfo = encoder.follow(fieldInfo);
            Field<?> finalField = finalFieldInfo.getField();
            name = finalField.getName();
            memberName = finalFieldInfo.getMemberName();
            if (encoder instanceof TermFrequencyEncoder) {
                argTypes = new JType[]{codeModel.INT};
            }
        } else {
            memberName = fieldInfo.getMemberName();
        }
        JMethod method = argumentsClazz.getMethod(memberName, argTypes);
        if (method != null) {
            return method;
        }
        if (encoder != null) {
            try {
                context.pushOwner(argumentsClazz);
                encoderMethod = encoder.createEncoderMethod(fieldInfo, context);
            }
            finally {
                context.popOwner();
            }
        }
        try {
            context.pushOwner(argumentsClazz);
            encoderMethod = ArgumentsRef.createEncoderMethod(field, context);
        }
        finally {
            context.popOwner();
        }
        JType type = encoderMethod.type();
        method = argumentsClazz.method(1, type, memberName);
        JVar indexParam = null;
        if (encoder instanceof TermFrequencyEncoder) {
            indexParam = method.param((JType)codeModel.INT, "index");
        }
        JBlock block = method.body();
        JInvocation valueExpr = encoder instanceof TermFrequencyEncoder ? JExpr.invoke((JMethod)encoderMethod).arg((JExpression)indexParam) : JExpr.invoke((JMethod)encoderMethod).arg(context.constantFieldName(name, true));
        Integer count = fieldInfo.getCount();
        if (count != null && count > 1) {
            JFieldVar fieldVar;
            JExpression initExpr = encoder != null ? encoder.createInitExpression(fieldInfo, context) : ArgumentsRef.createInitExpression(field, context);
            if (encoder instanceof ArrayEncoder) {
                fieldVar = (JFieldVar)argumentsClazz.fields().get(memberName);
                if (fieldVar == null) {
                    ArrayEncoder arrayEncoder = (ArrayEncoder)fieldInfo.getEncoder();
                    fieldVar = argumentsClazz.field(4, (JType)type.array(), memberName, (JExpression)JExpr.newArray((JType)type, (int)arrayEncoder.getLength()));
                    JBlock init = argumentsClazz.instanceInit();
                    init.add((JStatement)context.ref(Arrays.class).staticInvoke("fill").arg((JExpression)fieldVar).arg(initExpr));
                }
            } else {
                fieldVar = argumentsClazz.field(4, type, memberName, initExpr);
            }
            JFieldRef fieldVarRef = JExpr.refthis((String)fieldVar.name());
            if (encoder instanceof ArrayEncoder) {
                fieldVarRef = fieldVarRef.component((JExpression)indexParam);
            }
            JBlock thenBlock = block._if(fieldVarRef.eq(initExpr))._then();
            thenBlock.assign((JAssignmentTarget)fieldVarRef, (JExpression)valueExpr);
            block._return((JExpression)fieldVarRef);
        } else {
            block._return((JExpression)valueExpr);
        }
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JMethod createEncoderMethod(Field<?> field, TranslationContext context) {
        JClass returnType;
        String name;
        JDefinedClass owner = context.getOwner();
        JClass fieldNameClazz = context.ref(FieldName.class);
        DataType dataType = field.getDataType();
        switch (dataType) {
            case STRING: {
                name = "toString";
                returnType = context.ref(String.class);
                break;
            }
            case INTEGER: {
                name = "toInteger";
                returnType = context.ref(Integer.class);
                break;
            }
            case FLOAT: {
                name = "toFloat";
                returnType = context.ref(Float.class);
                break;
            }
            case DOUBLE: {
                name = "toDouble";
                returnType = context.ref(Double.class);
                break;
            }
            case BOOLEAN: {
                name = "toBoolean";
                returnType = context.ref(Boolean.class);
                break;
            }
            default: {
                throw new UnsupportedAttributeException(field, (Enum)dataType);
            }
        }
        JMethod method = owner.getMethod(name, new JType[]{fieldNameClazz});
        if (method != null) {
            return method;
        }
        method = owner.method(4, (JType)returnType, name);
        JVar nameParam = method.param((JType)fieldNameClazz, "name");
        try {
            context.pushScope(new MethodScope(method));
            JVar valueVar = context.declare(FieldValue.class, "value", (JExpression)context.invoke((JExpression)JExpr.refthis((String)"context"), "evaluate", nameParam));
            FieldValueRef fieldValueRef = new FieldValueRef(valueVar, dataType);
            context._return(JOp.cond((JExpression)valueVar.ne(JExpr._null()), (JExpression)fieldValueRef.asJavaValue(), (JExpression)JExpr._null()));
        }
        finally {
            context.popScope();
        }
        return method;
    }

    private static JExpression createInitExpression(Field<?> field, TranslationContext context) {
        String name;
        JDefinedClass owner = context.getOwner();
        DataType dataType = field.getDataType();
        switch (dataType) {
            case STRING: {
                name = "INIT_STRING_VALUE";
                break;
            }
            case INTEGER: {
                name = "INIT_INTEGER_VALUE";
                break;
            }
            case FLOAT: {
                name = "INIT_FLOAT_VALUE";
                break;
            }
            case DOUBLE: {
                name = "INIT_DOUBLE_VALUE";
                break;
            }
            case BOOLEAN: {
                name = "INIT_BOOLEAN_VALUE";
                break;
            }
            default: {
                throw new IllegalArgumentException(dataType.toString());
            }
        }
        JFieldVar constantVar = (JFieldVar)owner.fields().get(name);
        if (constantVar == null) {
            JInvocation initExpr;
            JClass type;
            switch (dataType) {
                case STRING: {
                    type = context.ref(String.class);
                    initExpr = JExpr._new((JType)type);
                    break;
                }
                case INTEGER: {
                    type = context.ref(Integer.class);
                    initExpr = JExpr._new((JType)type).arg(JExpr.lit((int)-999));
                    break;
                }
                case FLOAT: {
                    type = context.ref(Float.class);
                    initExpr = JExpr._new((JType)type).arg(JExpr.lit((float)-999.0f));
                    break;
                }
                case DOUBLE: {
                    type = context.ref(Double.class);
                    initExpr = JExpr._new((JType)type).arg(JExpr.lit((double)-999.0));
                    break;
                }
                case BOOLEAN: {
                    type = context.ref(Boolean.class);
                    initExpr = JExpr._new((JType)type).arg(JExpr.lit((boolean)false));
                    break;
                }
                default: {
                    throw new IllegalArgumentException(dataType.toString());
                }
            }
            constantVar = owner.field(28, (JType)type, name, (JExpression)initExpr);
        }
        return owner.staticRef((JVar)constantVar);
    }
}

