/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator;

import java.util.List;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.ParameterField;
import org.dmg.pmml.TextIndex;
import org.jpmml.translator.FunctionInvocation;
import org.jpmml.translator.FunctionInvocationContext;

public class FunctionInvocationUtil {
    private FunctionInvocationUtil() {
    }

    public static FunctionInvocation match(Expression expression, FunctionInvocationContext context) {
        if (expression instanceof FieldRef) {
            return FunctionInvocationUtil.matchFieldRef((FieldRef)expression, context);
        }
        if (expression instanceof TextIndex) {
            return FunctionInvocationUtil.matchTextIndex((TextIndex)expression, context);
        }
        if (expression instanceof Apply) {
            return FunctionInvocationUtil.matchApply((Apply)expression, context);
        }
        return null;
    }

    public static FunctionInvocation matchFieldRef(final FieldRef fieldRef, FunctionInvocationContext context) {
        return new FunctionInvocation.Ref(){

            @Override
            public FieldName getField() {
                return fieldRef.getField();
            }
        };
    }

    public static FunctionInvocation matchTextIndex(final TextIndex textIndex, final FunctionInvocationContext context) {
        return new FunctionInvocation.Tf(){

            @Override
            public TextIndex getTextIndex() {
                return textIndex;
            }

            @Override
            public FieldName getTextField() {
                TextIndex textIndex2 = this.getTextIndex();
                return context.resolve(textIndex2.getTextField());
            }

            @Override
            public String getTerm() {
                TextIndex textIndex2 = this.getTextIndex();
                Constant constant = (Constant)context.resolve(textIndex2.getExpression());
                return (String)constant.getValue();
            }
        };
    }

    public static FunctionInvocation matchApply(Apply apply, final FunctionInvocationContext context) {
        String function = apply.getFunction();
        final List expressions = apply.getExpressions();
        if ("*".equals(function) && expressions.size() == 2) {
            FunctionInvocation functionInvocation = FunctionInvocationUtil.match((Expression)expressions.get(0), context);
            if (functionInvocation instanceof FunctionInvocation.Tf) {
                final FunctionInvocation.Tf tf = (FunctionInvocation.Tf)functionInvocation;
                return new FunctionInvocation.TfIdf(){

                    @Override
                    public FunctionInvocation.Tf getTf() {
                        return tf;
                    }

                    @Override
                    public Number getWeight() {
                        Constant constant = (Constant)context.resolve((Expression)expressions.get(1));
                        return (Number)constant.getValue();
                    }
                };
            }
        } else {
            DefineFunction defineFunction = context.getDefineFunction(function);
            if (defineFunction != null) {
                Expression expression = defineFunction.getExpression();
                FunctionInvocationContext defineFunctionContext = new FunctionInvocationContext(){

                    @Override
                    public DefineFunction getDefineFunction(String name) {
                        return context.getDefineFunction(name);
                    }
                };
                if (defineFunction.hasParameterFields()) {
                    List parameterFields = defineFunction.getParameterFields();
                    for (int i = 0; i < parameterFields.size(); ++i) {
                        defineFunctionContext.put(((ParameterField)parameterFields.get(i)).getName(), expressions.get(i));
                    }
                }
                return FunctionInvocationUtil.match(expression, defineFunctionContext);
            }
        }
        return null;
    }
}

