/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator;

import com.sun.codemodel.JMethod;
import com.sun.codemodel.JTypeVar;
import com.sun.codemodel.JVar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jpmml.translator.Scope;

public class MethodScope
extends Scope {
    private JMethod method = null;
    private Map<String, JTypeVar> typeVariables = null;
    public static final String TYPEVAR_NUMBER = "V";

    public MethodScope(JMethod method) {
        super(method.body());
        JTypeVar[] typeParams;
        this.setMethod(method);
        List params = method.params();
        for (JVar param : params) {
            this.declare(param);
        }
        boolean hasVarArgs = method.hasVarArgs();
        if (hasVarArgs) {
            JVar varParam = method.listVarParam();
            this.declare(varParam);
        }
        for (JTypeVar typeParam : typeParams = method.typeParams()) {
            this.declare(typeParam);
        }
    }

    public JTypeVar getTypeVariable(String name) {
        if (this.typeVariables == null) {
            return null;
        }
        return this.typeVariables.get(name);
    }

    public void declare(JTypeVar typeParam) {
        if (this.typeVariables == null) {
            this.typeVariables = new LinkedHashMap<String, JTypeVar>();
        }
        this.typeVariables.put(typeParam.name(), typeParam);
    }

    public JMethod getMethod() {
        return this.method;
    }

    private void setMethod(JMethod method) {
        this.method = method;
    }
}

