/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator;

import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLElements;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.mining.Segment;
import org.jpmml.converter.visitors.DataDictionaryCleaner;
import org.jpmml.converter.visitors.FunctionDictionaryCleaner;
import org.jpmml.converter.visitors.MiningSchemaCleaner;
import org.jpmml.converter.visitors.TransformationDictionaryCleaner;
import org.jpmml.model.ReflectionUtil;
import org.jpmml.model.visitors.AbstractVisitor;
import org.jpmml.model.visitors.VisitorBattery;
import org.jpmml.translator.JWrappedExpression;
import org.jpmml.translator.PMMLObjectUtil;
import org.jpmml.translator.Template;
import org.jpmml.translator.TranslatedModel;
import org.jpmml.translator.TranslationContext;

public class PMMLTemplate
extends Template {
    PMMLTemplate(Class<? extends PMML> clazz) {
        super(clazz, PMMLTemplate.getFields(clazz));
    }

    @Override
    public JInvocation initializeObject(PMMLObject object, JInvocation invocation, TranslationContext context) {
        PMML pmml = (PMML)object;
        List<Field> setterMethodFields = this.getSetterMethodFields();
        Field modelsField = PMMLElements.PMML_MODELS;
        List models = pmml.getModels();
        invocation = PMMLObjectUtil.addSetterMethod(modelsField, models, invocation, context);
        final Map<Model, TranslatedModel> translations = context.getTranslations();
        if (!translations.isEmpty()) {
            AbstractVisitor visitor = new AbstractVisitor(){

                public VisitorAction visit(PMML pmml) {
                    if (pmml.hasModels()) {
                        List models = pmml.getModels();
                        ListIterator<Model> it = models.listIterator();
                        while (it.hasNext()) {
                            it.set(this.filter((Model)it.next()));
                        }
                    }
                    return super.visit(pmml);
                }

                public VisitorAction visit(Segment segment) {
                    segment.setModel(this.filter(segment.getModel()));
                    return super.visit(segment);
                }

                private Model filter(Model model) {
                    TranslatedModel translatedModel = (TranslatedModel)((Object)translations.get(model));
                    if (translatedModel != null) {
                        return translatedModel;
                    }
                    return model;
                }
            };
            VisitorBattery visitorBattery = new VisitorBattery();
            visitorBattery.add(TransformationDictionaryCleaner.class);
            visitorBattery.add(DataDictionaryCleaner.class);
            visitorBattery.add(FunctionDictionaryCleaner.class);
            visitorBattery.add(MiningSchemaCleaner.class);
            visitor.applyTo((Visitable)pmml);
            visitorBattery.applyTo((Visitable)pmml);
            Collection<TranslatedModel> translatedModels = translations.values();
            for (TranslatedModel translatedModel : translatedModels) {
                Model model = translatedModel.getModel();
                JWrappedExpression expression = translatedModel.getExpression();
                expression.setExpression((JExpression)PMMLObjectUtil.initializeJavaModel(model, (JInvocation)expression.getExpression(), context));
            }
        }
        setterMethodFields.remove(modelsField);
        for (Field setterMethodField : setterMethodFields) {
            Object value = ReflectionUtil.getFieldValue((Field)setterMethodField, (Object)object);
            invocation = PMMLObjectUtil.addSetterMethod(setterMethodField, value, invocation, context);
        }
        return invocation;
    }

    private static List<Field> getFields(Class<? extends PMML> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>(ReflectionUtil.getFields(clazz));
        fields.remove(PMMLElements.PMML_TRANSFORMATIONDICTIONARY);
        fields.add(fields.size(), PMMLElements.PMML_TRANSFORMATIONDICTIONARY);
        return fields;
    }
}

