/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JMods;
import com.sun.codemodel.JOp;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JSwitch;
import com.sun.codemodel.JType;
import com.sun.codemodel.JTypeVar;
import com.sun.codemodel.JVar;
import java.lang.reflect.Constructor;
import java.lang.reflect.TypeVariable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.jpmml.evaluator.PMMLException;
import org.jpmml.evaluator.UnsupportedAttributeException;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueMap;
import org.jpmml.translator.ArgumentsRef;
import org.jpmml.translator.ArrayManager;
import org.jpmml.translator.Encoder;
import org.jpmml.translator.EvaluationContextRef;
import org.jpmml.translator.FieldInfo;
import org.jpmml.translator.IdentifierUtil;
import org.jpmml.translator.JBinaryFileInitializer;
import org.jpmml.translator.MethodScope;
import org.jpmml.translator.NumberRef;
import org.jpmml.translator.OperableRef;
import org.jpmml.translator.PMMLObjectUtil;
import org.jpmml.translator.PrimitiveRef;
import org.jpmml.translator.Scope;
import org.jpmml.translator.StringRef;
import org.jpmml.translator.TermFrequencyEncoder;
import org.jpmml.translator.TranslatedModel;
import org.jpmml.translator.ValueFactoryRef;
import org.jpmml.translator.tree.TreeModelTranslator;

public class TranslationContext {
    private PMML pmml = null;
    private JCodeModel codeModel = null;
    private List<PMMLException> issues = new ArrayList<PMMLException>();
    private Deque<JDefinedClass> owners = new ArrayDeque<JDefinedClass>();
    private Deque<Scope> scopes = new ArrayDeque<Scope>();
    private ArrayManager<FieldName> fieldNameManager = null;
    private ArrayManager<QName> xmlNameManager = null;
    private Map<Model, TranslatedModel> translations = new IdentityHashMap<Model, TranslatedModel>();
    private Set<FieldName> activeFieldNames = new LinkedHashSet<FieldName>();

    public TranslationContext(PMML pmml, JCodeModel codeModel) {
        this.setPMML(pmml);
        this.setCodeModel(codeModel);
    }

    public JClass ref(Class<?> type) {
        JCodeModel codeModel = this.getCodeModel();
        return codeModel.ref(type);
    }

    public JType _ref(Class<?> type) {
        JCodeModel codeModel = this.getCodeModel();
        return codeModel._ref(type);
    }

    public JDefinedClass getOwner() {
        return this.owners.getFirst();
    }

    public void pushOwner(final JDefinedClass owner) {
        if (TranslationContext.isSubclass(PMML.class, owner)) {
            this.fieldNameManager = new ArrayManager<FieldName>((JType)this.ref(FieldName.class), "fieldNames"){
                {
                    super(componentType, name);
                    this.initArrayVar(owner);
                }

                @Override
                public JExpression createExpression(FieldName name) {
                    return TranslationContext.this.staticInvoke(FieldName.class, "create", name.getValue());
                }
            };
            this.xmlNameManager = new ArrayManager<QName>((JType)this.ref(QName.class), "xmlNames"){
                {
                    super(componentType, name);
                    this.initArrayVar(owner);
                }

                @Override
                public JExpression createExpression(QName name) {
                    return TranslationContext.this._new(QName.class, name.getNamespaceURI(), name.getLocalPart(), name.getPrefix());
                }
            };
        }
        this.owners.addFirst(owner);
    }

    public void popOwner() {
        JDefinedClass owner = this.owners.peekFirst();
        if (TranslationContext.isSubclass(PMML.class, owner)) {
            PMML pmml = this.getPMML();
            JBinaryFileInitializer resourceInitializer = new JBinaryFileInitializer(IdentifierUtil.create(PMML.class.getSimpleName(), (PMMLObject)pmml) + ".data", 0, this);
            FieldName[] fieldNames = this.fieldNameManager.getElements().toArray(new FieldName[this.fieldNameManager.size()]);
            resourceInitializer.initFieldNames(this.fieldNameManager.getArrayVar(), fieldNames);
            QName[] xmlNames = this.xmlNameManager.getElements().toArray(new QName[this.xmlNameManager.size()]);
            resourceInitializer.initQNames(this.xmlNameManager.getArrayVar(), xmlNames);
        }
        this.owners.removeFirst();
    }

    public JVar getVariable(String name) {
        for (Scope scope : this.scopes) {
            JVar variable = scope.getVariable(name);
            if (variable == null) continue;
            return variable;
        }
        throw new IllegalArgumentException(name);
    }

    public ArgumentsRef getArgumentsVariable() {
        JVar variable;
        JDefinedClass owner = this.getOwner();
        if ("Arguments".equals(owner.name())) {
            try {
                Constructor constuctor = JVar.class.getDeclaredConstructor(JMods.class, JType.class, String.class, JExpression.class);
                if (!constuctor.isAccessible()) {
                    constuctor.setAccessible(true);
                }
                variable = (JVar)constuctor.newInstance(null, owner, "this", null);
            }
            catch (ReflectiveOperationException roe) {
                throw new RuntimeException(roe);
            }
        } else {
            variable = this.getVariable("arguments");
        }
        return new ArgumentsRef(variable);
    }

    public EvaluationContextRef getContextVariable() {
        JVar variable = this.getVariable("context");
        return new EvaluationContextRef(variable);
    }

    public ValueFactoryRef getValueFactoryVariable() {
        JVar variable = this.getVariable("valueFactory");
        return new ValueFactoryRef(variable);
    }

    public boolean isNonMissing(JVar variable) {
        for (Scope scope : this.scopes) {
            if (!scope.isNonMissing(variable)) continue;
            return true;
        }
        return false;
    }

    public void markNonMissing(JVar variable) {
        Scope scope = this.ensureOpenScope();
        scope.markNonMissing(variable);
    }

    public OperableRef ensureOperableVariable(FieldInfo fieldInfo) {
        JVar variable;
        String variableName;
        Field<?> field = fieldInfo.getField();
        Encoder encoder = fieldInfo.getEncoder();
        DataType dataType = field.getDataType();
        if (encoder != null) {
            FieldInfo finalFieldInfo = encoder.follow(fieldInfo);
            variableName = finalFieldInfo.getVariableName();
        } else {
            variableName = fieldInfo.getVariableName();
        }
        try {
            variable = this.getVariable(variableName);
        }
        catch (IllegalArgumentException iae) {
            JExpression[] initArgExprs = new JExpression[]{};
            if (encoder instanceof TermFrequencyEncoder) {
                TermFrequencyEncoder termFrequencyEncoder = (TermFrequencyEncoder)encoder;
                TreeModelTranslator.ensureTextIndexFields(fieldInfo, termFrequencyEncoder, this);
                initArgExprs = new JExpression[]{JExpr.lit((int)termFrequencyEncoder.getIndex())};
            }
            ArgumentsRef argumentsRef = this.getArgumentsVariable();
            JMethod method = argumentsRef.getMethod(fieldInfo, this);
            variable = this.declare(method.type(), variableName, (JExpression)argumentsRef.invoke(method, initArgExprs));
        }
        if (encoder != null) {
            return encoder.ref(variable);
        }
        switch (dataType) {
            case STRING: {
                return new StringRef(variable);
            }
            case INTEGER: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: {
                JType type = variable.type();
                if (type.isPrimitive()) {
                    return new PrimitiveRef(variable);
                }
                return new NumberRef(variable);
            }
        }
        throw new UnsupportedAttributeException(field, (Enum)dataType);
    }

    public JTypeVar getTypeVariable(String name) {
        for (Scope scope : this.scopes) {
            if (!(scope instanceof MethodScope)) continue;
            MethodScope methodScope = (MethodScope)scope;
            return methodScope.getTypeVariable(name);
        }
        throw new IllegalArgumentException(name);
    }

    public JTypeVar getNumberTypeVariable() {
        return this.getTypeVariable("V");
    }

    public JClass getValueType() {
        JTypeVar numberTypeVar = this.getNumberTypeVariable();
        return this.ref(Value.class).narrow((JClass)numberTypeVar);
    }

    public JClass getValueMapType() {
        JTypeVar numberTypeVar = this.getNumberTypeVariable();
        return this.ref(ValueMap.class).narrow(Arrays.asList(this.ref(Object.class), numberTypeVar));
    }

    public JVar declare(Class<?> type, String name, JExpression init) {
        return this.declare(this._ref(type), name, init);
    }

    public JVar declare(JType type, String name, JExpression init) {
        Scope scope = this.ensureOpenScope();
        return scope.declare(type, name, init);
    }

    public void add(JStatement statement) {
        Scope scope = this.ensureOpenScope();
        JBlock block = scope.getBlock();
        block.add(statement);
    }

    public void _returnIf(JExpression testExpr, JExpression resultExpr) {
        Scope scope = this.ensureOpenScope();
        JBlock block = scope.getBlock();
        JBlock thenBlock = block._if(testExpr)._then();
        thenBlock._return(resultExpr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _return(JExpression testExpr, JExpression trueResultExpr, JExpression falseResultExpr) {
        try (Scope scope = this.ensureOpenScope();){
            JBlock block = scope.getBlock();
            block._return(JOp.cond((JExpression)testExpr, (JExpression)trueResultExpr, (JExpression)falseResultExpr));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _return(JExpression resultExpr) {
        try (Scope scope = this.ensureOpenScope();){
            JBlock block = scope.getBlock();
            block._return(resultExpr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> void _return(JExpression valueExpr, Map<?, V> resultMap, V defaultResult) {
        try (Scope scope = this.ensureOpenScope();){
            JBlock block = scope.getBlock();
            JSwitch switchBlock = block._switch(valueExpr);
            Set<Map.Entry<?, V>> entries = resultMap.entrySet();
            for (Map.Entry entry : entries) {
                JBlock caseBlock = switchBlock._case(PMMLObjectUtil.createExpression(entry.getKey(), this)).body();
                caseBlock._return(PMMLObjectUtil.createExpression(entry.getValue(), this));
            }
            JBlock defaultBlock = switchBlock._default().body();
            defaultBlock._return(PMMLObjectUtil.createExpression(defaultResult, this));
        }
    }

    public JInvocation _new(Class<?> type, Object ... args) {
        TypeVariable<Class<?>>[] typeVariables = type.getTypeParameters();
        if (typeVariables.length > 0) {
            return this._new(this.ref(type).narrow(Collections.emptyList()), args);
        }
        return this._new(this.ref(type), args);
    }

    public JInvocation _new(JClass type, Object ... args) {
        List typeParameters = type.getTypeParameters();
        if (!typeParameters.isEmpty()) {
            type = type.erasure().narrow(Collections.emptyList());
        }
        JInvocation invocation = JExpr._new((JClass)type);
        for (Object arg : args) {
            invocation = invocation.arg(PMMLObjectUtil.createExpression(arg, this));
        }
        return invocation;
    }

    public JInvocation invoke(JVar variable, String method, Object ... args) {
        return this.invoke((JExpression)variable, method, args);
    }

    public JInvocation invoke(JExpression variable, String method, Object ... args) {
        JInvocation invocation = variable.invoke(method);
        for (Object arg : args) {
            invocation = invocation.arg(PMMLObjectUtil.createExpression(arg, this));
        }
        return invocation;
    }

    public JInvocation staticInvoke(Class<?> type, String method, Object ... args) {
        return this.staticInvoke(this.ref(type), method, args);
    }

    public JInvocation staticInvoke(JClass type, String method, Object ... args) {
        JInvocation invocation = type.staticInvoke(method);
        for (Object arg : args) {
            invocation = invocation.arg(PMMLObjectUtil.createExpression(arg, this));
        }
        return invocation;
    }

    public JBlock block() {
        Scope scope = this.ensureOpenScope();
        return scope.getBlock();
    }

    public Scope ensureOpenScope() {
        Scope scope = this.getScope();
        return scope.ensureOpen();
    }

    public Scope getScope() {
        return this.scopes.getFirst();
    }

    public void pushScope(Scope scope) {
        this.scopes.addFirst(scope);
    }

    public void popScope() {
        this.scopes.removeFirst();
    }

    public JExpression constantFieldName(FieldName name) {
        return this.constantFieldName(name, false);
    }

    public JExpression constantFieldName(FieldName name, boolean markActive) {
        if (name == null) {
            return JExpr._null();
        }
        ArrayManager<FieldName> fieldNameManager = this.fieldNameManager;
        if (markActive) {
            this.activeFieldNames.add(name);
        }
        int index = fieldNameManager.getOrInsert(name);
        return fieldNameManager.getComponent(index);
    }

    public JExpression constantXmlName(QName name) {
        ArrayManager<QName> xmlNameManager = this.xmlNameManager;
        int index = xmlNameManager.getOrInsert(name);
        return xmlNameManager.getComponent(index);
    }

    public void addIssue(PMMLException issue) {
        this.issues.add(issue);
    }

    public PMML getPMML() {
        return this.pmml;
    }

    private void setPMML(PMML pmml) {
        this.pmml = pmml;
    }

    public JCodeModel getCodeModel() {
        return this.codeModel;
    }

    private void setCodeModel(JCodeModel codeModel) {
        this.codeModel = codeModel;
    }

    public List<PMMLException> getIssues() {
        return this.issues;
    }

    public Map<Model, TranslatedModel> getTranslations() {
        return this.translations;
    }

    public void addTranslation(Model model, TranslatedModel translatedModel) {
        this.translations.put(model, translatedModel);
    }

    public Set<FieldName> getActiveFieldNames() {
        return this.activeFieldNames;
    }

    private static boolean isSubclass(Class<?> clazz, JDefinedClass owner) {
        JClass superClazz = owner._extends();
        return clazz.getName().equals(superClazz.fullName());
    }
}

